/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.suggestion;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import dev.qixils.relocated.cloud.suggestion.NoSuggestions;
import dev.qixils.relocated.cloud.suggestion.Suggestion;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
@FunctionalInterface
public interface SuggestionProvider<C> {
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> var1, @NonNull CommandInput var2);

    public static <C> @NonNull SuggestionProvider<C> noSuggestions() {
        return NoSuggestions.instance();
    }

    public static <C> @NonNull SuggestionProvider<C> blocking(@NonNull BlockingSuggestionProvider<C> blockingSuggestionProvider) {
        return blockingSuggestionProvider;
    }

    public static <C> @NonNull SuggestionProvider<C> blockingStrings(@NonNull BlockingSuggestionProvider.Strings<C> blockingStringsSuggestionProvider) {
        return blockingStringsSuggestionProvider;
    }

    public static <C> @NonNull SuggestionProvider<C> suggesting(Suggestion ... suggestions) {
        return SuggestionProvider.suggesting(Arrays.asList(suggestions));
    }

    public static <C> @NonNull SuggestionProvider<C> suggestingStrings(String ... suggestions) {
        return SuggestionProvider.suggestingStrings(Arrays.asList(suggestions));
    }

    public static <C> @NonNull SuggestionProvider<C> suggesting(@NonNull Iterable<? extends @NonNull Suggestion> suggestions) {
        return SuggestionProvider.blocking((ctx, input) -> suggestions);
    }

    public static <C> @NonNull SuggestionProvider<C> suggestingStrings(@NonNull Iterable<@NonNull String> suggestions) {
        return SuggestionProvider.blockingStrings((ctx, input) -> suggestions);
    }
}

