/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.type.range;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.type.range.ByteRange;
import dev.qixils.relocated.cloud.type.range.ByteRangeImpl;
import dev.qixils.relocated.cloud.type.range.DoubleRange;
import dev.qixils.relocated.cloud.type.range.DoubleRangeImpl;
import dev.qixils.relocated.cloud.type.range.FloatRange;
import dev.qixils.relocated.cloud.type.range.FloatRangeImpl;
import dev.qixils.relocated.cloud.type.range.IntRange;
import dev.qixils.relocated.cloud.type.range.IntRangeImpl;
import dev.qixils.relocated.cloud.type.range.LongRange;
import dev.qixils.relocated.cloud.type.range.LongRangeImpl;
import dev.qixils.relocated.cloud.type.range.ShortRange;
import dev.qixils.relocated.cloud.type.range.ShortRangeImpl;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public interface Range<N extends Number> {
    public @NonNull N min();

    public @NonNull N max();

    public static @NonNull ByteRange byteRange(byte min, byte max) {
        return ByteRangeImpl.of(min, max);
    }

    public static @NonNull DoubleRange doubleRange(double min, double max) {
        return DoubleRangeImpl.of(min, max);
    }

    public static @NonNull FloatRange floatRange(float min, float max) {
        return FloatRangeImpl.of(min, max);
    }

    public static @NonNull IntRange intRange(int min, int max) {
        return IntRangeImpl.of(min, max);
    }

    public static @NonNull LongRange longRange(long min, long max) {
        return LongRangeImpl.of(min, max);
    }

    public static @NonNull ShortRange shortRange(short min, short max) {
        return ShortRangeImpl.of(min, max);
    }
}

