/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.exp;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public class ExpAddCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "xp_add";
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND;
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        List<P> players = playerSupplier.get();
        int amount = Math.max(1, request.getQuantity());
        Stream<MCCCPlayer> streamers = players.stream().map(this.plugin::getPlayer);
        this.sync(() -> streamers.forEach(player -> player.addXpLevel(amount)));
        ccPlayer.sendResponse(new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @NotNull
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }

    public ExpAddCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

