/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.configurate;

import dev.qixils.crowdcontrol.common.CustomEffectsConfig;
import dev.qixils.crowdcontrol.common.HideNames;
import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.SoftLockConfig;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;

public abstract class ConfiguratePlugin<P, S>
extends Plugin<P, S> {
    @NotNull
    protected Path dataFolder = Paths.get("config", "CrowdControlData");

    public ConfiguratePlugin(@NotNull Class<P> playerClass, @NotNull Class<S> commandSenderClass) {
        super(playerClass, commandSenderClass);
    }

    protected abstract ConfigurationLoader<?> getConfigLoader() throws IllegalStateException;

    @Override
    public void loadConfig() {
        Object config;
        try {
            config = this.getConfigLoader().load();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load plugin config", e);
        }
        this.softLockConfig = new SoftLockConfig(config.node("soft-lock-observer", "period").getInt(120), config.node("soft-lock-observer", "deaths").getInt(6), config.node("soft-lock-observer", "search-horizontal").getInt(20), config.node("soft-lock-observer", "search-vertical").getInt(8));
        this.customEffectsConfig = new CustomEffectsConfig(config.node("custom-effects", "enabled").getBoolean(true));
        TypeToken<Set<String>> hostToken = new TypeToken<Set<String>>(this){};
        try {
            this.hosts = Collections.unmodifiableSet(config.node("hosts").get(hostToken, new HashSet(this.hosts)));
        }
        catch (SerializationException e) {
            throw new RuntimeException("Could not parse 'hosts' config variable", e);
        }
        if (!this.hosts.isEmpty()) {
            HashSet<String> loweredHosts = new HashSet<String>(this.hosts.size());
            for (String host : this.hosts) {
                loweredHosts.add(host.toLowerCase(Locale.ROOT));
            }
            this.hosts = Collections.unmodifiableSet(loweredHosts);
        }
        boolean hostsBypass = config.node("limits", "hosts-bypass").getBoolean(this.limitConfig.hostsBypass());
        TypeToken<Map<String, Integer>> limitToken = new TypeToken<Map<String, Integer>>(this){};
        try {
            Map<String, Integer> itemLimits = config.node("limits", "items").get(limitToken, this.limitConfig.itemLimits());
            Map<String, Integer> entityLimits = config.node("limits", "entities").get(limitToken, this.limitConfig.entityLimits());
            this.limitConfig = new LimitConfig(hostsBypass, itemLimits, entityLimits);
        }
        catch (SerializationException e) {
            this.getSLF4JLogger().warn("Could not parse limits config", (Throwable)e);
        }
        this.global = config.node("global").getBoolean(this.global);
        this.announce = config.node("announce").getBoolean(this.announce);
        this.adminRequired = config.node("admin-required").getBoolean(this.adminRequired);
        this.hideNames = HideNames.fromConfigCode(config.node("hide-names").getString(this.hideNames.getConfigCode()));
    }

    public void saveConfig() {
        try {
            Object config = this.getConfigLoader().createNode();
            TypeToken<Set<String>> hostToken = new TypeToken<Set<String>>(this){};
            TypeToken<Map<String, Integer>> limitToken = new TypeToken<Map<String, Integer>>(this){};
            config.node("hosts").set(hostToken, new HashSet(this.hosts));
            config.node("limits", "hosts-bypass").set(this.limitConfig.hostsBypass());
            config.node("limits", "items").set(limitToken, this.limitConfig.itemLimits());
            config.node("limits", "entities").set(limitToken, this.limitConfig.entityLimits());
            config.node("global").set(this.global);
            config.node("announce").set(this.announce);
            config.node("hide-names").set(this.hideNames.getConfigCode());
            config.node("soft-lock-observer", "period").set(this.softLockConfig.getPeriod());
            config.node("soft-lock-observer", "deaths").set(this.softLockConfig.getDeaths());
            config.node("soft-lock-observer", "search-horizontal").set(this.softLockConfig.getSearchH());
            config.node("soft-lock-observer", "search-vertical").set(this.softLockConfig.getSearchV());
            config.node("custom-effects", "enabled").set(this.customEffectsConfig.enabled());
            this.getConfigLoader().save((ConfigurationNode)config);
        }
        catch (ConfigurateException e) {
            throw new RuntimeException("Could not save plugin config", e);
        }
    }

    @NotNull
    protected Path fixConfigDirectory(@NotNull Path configDirectory) {
        if (configDirectory.getFileName().toString().equals("crowdcontrol.conf")) {
            configDirectory = configDirectory.getParent();
        }
        return configDirectory;
    }

    @CheckReturnValue
    protected HoconConfigurationLoader createConfigLoader(@NotNull Path configDirectory) throws IllegalStateException {
        configDirectory = this.fixConfigDirectory(configDirectory);
        this.dataFolder = configDirectory.resolve("CrowdControlData");
        if (!Files.exists(configDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(configDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create config directory", e);
            }
        }
        Path configPath = configDirectory.resolve("crowdcontrol.conf");
        Path oldConfigPath = configDirectory.resolve("crowd-control.conf");
        if (Files.exists(oldConfigPath, new LinkOption[0])) {
            try {
                Files.move(oldConfigPath, configPath, new CopyOption[0]);
            }
            catch (Exception e) {
                this.getSLF4JLogger().warn("Could not move old config file to new location", (Throwable)e);
            }
        }
        if (!Files.exists(configPath, new LinkOption[0])) {
            InputStream inputStream = this.getInputStream("assets/crowdcontrol/default.conf");
            if (inputStream == null) {
                throw new IllegalStateException("Could not find default config file");
            }
            try {
                Files.copy(inputStream, configPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not copy default config file to " + String.valueOf(configPath), e);
            }
        }
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(configPath)).build();
    }

    @Override
    @NotNull
    public Path getDataFolder() {
        return this.dataFolder;
    }
}

