/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExplodeCommand
extends ModdedCommand {
    private final String effectName = "explode";

    public ExplodeCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            float power = (float)CommandConstants.explosionPower();
            boolean fire = CommandConstants.shouldSpawnFire();
            for (ServerPlayer player : (List)playerSupplier.get()) {
                this.sync(() -> {
                    Vec3 pos = player.position().subtract(0.0, 0.5, 0.0);
                    player.serverLevel().explode(null, pos.x, pos.y, pos.z, power, fire, Level.ExplosionInteraction.TNT);
                    player.setDeltaMovement(0.0, 0.5, 0.0);
                    player.hurtMarked = true;
                });
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

