/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public abstract class ItemDurabilityCommand
extends ModdedCommand {
    private final String effectName;

    protected ItemDurabilityCommand(ModdedCrowdControlPlugin plugin, String effectName) {
        super(plugin);
        this.effectName = effectName;
    }

    protected abstract int modifyDurability(int var1, int var2);

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List<EquipmentSlot> slots = Arrays.asList(EquipmentSlot.values());
            Collections.shuffle(slots);
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                for (EquipmentSlot slot : slots) {
                    int maxDamage;
                    int newDamage;
                    int curDamage;
                    ItemStack item = player.getItemBySlot(slot);
                    if (item.isEmpty() || !item.isDamageableItem() || !CommandConstants.canApplyDamage(curDamage = item.getDamageValue(), newDamage = Math.min(maxDamage = item.getMaxDamage(), Math.max(0, this.modifyDurability(curDamage, maxDamage))), maxDamage)) continue;
                    success = true;
                    item.setDamageValue(newDamage);
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Targets not holding a durable item");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public static final class Damage
    extends ItemDurabilityCommand {
        public Damage(ModdedCrowdControlPlugin plugin) {
            super(plugin, "damage_item");
        }

        @Override
        protected int modifyDurability(int curDamage, int maxDamage) {
            return curDamage + maxDamage / 4;
        }
    }

    @NotNull
    public static final class Repair
    extends ItemDurabilityCommand {
        public Repair(ModdedCrowdControlPlugin plugin) {
            super(plugin, "repair_item");
        }

        @Override
        protected int modifyDurability(int curDamage, int maxDamage) {
            return 0;
        }
    }
}

