/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class PotionCommand
extends ModdedCommand
implements CCTimedEffect {
    @NotNull
    private final Holder<MobEffect> potionEffectType;
    private final boolean isMinimal;
    @NotNull
    private final String effectName;
    @NotNull
    private final Component displayName;
    private final CCName extensionName;
    private final String image = "potion_speed";
    private final int price = 50;
    private final byte priority = 0;
    private final boolean exclusive;
    private final List<String> categories = Collections.singletonList("Potion Effects");
    private final CustomEffectDuration extensionDuration = new CustomEffectDuration(20.0);

    public PotionCommand(@NotNull ModdedCrowdControlPlugin plugin, @NotNull Holder<MobEffect> potionEffectType) {
        super(plugin);
        this.potionEffectType = potionEffectType;
        ResourceLocation loc = ((ResourceKey)potionEffectType.unwrapKey().orElseThrow()).location();
        this.effectName = "potion_" + CommandConstants.asMinimalSafeString((Key)loc);
        this.isMinimal = ((MobEffect)potionEffectType.value()).isInstantenous();
        TranslatableComponent _displayName = Component.translatable((String)"cc.effect.potion.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(((MobEffect)potionEffectType.value()).getDisplayName())});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.potion.extension")));
        this.exclusive = potionEffectType.is(MobEffects.BLINDNESS) || potionEffectType.is(MobEffects.DARKNESS) || potionEffectType.is(MobEffects.FIRE_RESISTANCE) || potionEffectType.is(MobEffects.GLOWING) || potionEffectType.is(MobEffects.INFESTED) || potionEffectType.is(MobEffects.INVISIBILITY) || potionEffectType.is(MobEffects.NAUSEA) || potionEffectType.is(MobEffects.NIGHT_VISION) || potionEffectType.is(MobEffects.SLOW_FALLING) || potionEffectType.is(MobEffects.WATER_BREATHING);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.potionEffectType == MobEffects.JUMP_BOOST && this.isActive(ccPlayer, "disable_jumping")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot apply jump boost while Disable Jump is active");
            }
            Duration duration = Duration.ofMillis(request.getEffect().getDurationMillis());
            int durationTicks = this.isMinimal ? 1 : (int)duration.getSeconds() * 20;
            for (ServerPlayer player : (List)playerSupplier.get()) {
                MobEffectInstance effect = new MobEffectInstance(this.potionEffectType, durationTicks);
                MobEffectInstance existingEffect = player.getEffect(this.potionEffectType);
                if (existingEffect == null) {
                    this.plugin.getSLF4JLogger().debug("Adding new effect");
                    player.addEffect(effect);
                    continue;
                }
                this.plugin.getSLF4JLogger().debug("Updating existing effect");
                int oldDuration = existingEffect.getDuration();
                int newDuration = oldDuration == -1 ? -1 : Math.max(durationTicks, oldDuration);
                int newAmplifier = existingEffect.getAmplifier() + 1;
                if (this.potionEffectType == MobEffects.LEVITATION && newAmplifier > 127) {
                    --newAmplifier;
                }
                player.forceAddEffect(new MobEffectInstance(this.potionEffectType, newDuration, newAmplifier, existingEffect.isAmbient(), existingEffect.isVisible(), existingEffect.showIcon()), null);
            }
            return this.isMinimal ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }, this.plugin.getSyncExecutor()));
    }

    @NotNull
    public Holder<MobEffect> getPotionEffectType() {
        return this.potionEffectType;
    }

    public boolean isMinimal() {
        return this.isMinimal;
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public CustomEffectDuration getExtensionDuration() {
        return this.extensionDuration;
    }
}

