/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import com.mojang.blaze3d.platform.WindowEventHandler;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.client.ClientMinecraftEvents;
import live.crowdcontrol.cc4j.CrowdControl;
import net.minecraft.client.Minecraft;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler {
    public MinecraftClientMixin() {
        super("Client");
    }

    @Inject(method={"runTick(Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;pause:Z", opcode=181, shift=At.Shift.AFTER)})
    private void injected(CallbackInfo ci) {
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        ModdedCrowdControlPlugin plugin = ModdedCrowdControlPlugin.getInstance();
        CrowdControl cc = plugin.getCrowdControl();
        if (cc == null) {
            return;
        }
        boolean paused = ((Minecraft)this).isPaused();
        if (plugin.isPaused() == paused) {
            return;
        }
        plugin.setPaused(paused);
        if (paused) {
            cc.pauseAll();
        } else {
            cc.resumeAll();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lorg/slf4j/Logger;info(Ljava/lang/String;)V", shift=At.Shift.AFTER, remap=false)}, method={"destroy()V"})
    private void onStopping(CallbackInfo ci) {
        ClientMinecraftEvents.CLIENT_STOPPING.fire((Minecraft)this);
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;gameThread:Ljava/lang/Thread;", shift=At.Shift.AFTER, ordinal=0)}, method={"run()V"})
    private void onStart(CallbackInfo ci) {
        ClientMinecraftEvents.CLIENT_STARTED.fire((Minecraft)this);
    }
}

