/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import dev.qixils.crowdcontrol.plugin.fabric.commands.FreezeCommand;
import dev.qixils.crowdcontrol.plugin.fabric.interfaces.Components;
import dev.qixils.crowdcontrol.plugin.fabric.interfaces.GameTypeEffectComponent;
import dev.qixils.crowdcontrol.plugin.fabric.utils.EntityUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements GameTypeEffectComponent {
    @Unique
    GameType cc$gameTypeEffect;

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Override
    @Nullable
    public GameType cc$getGameTypeEffect() {
        return this.cc$gameTypeEffect;
    }

    @Override
    public void cc$setGameTypeEffect(GameType gameTypeEffect) {
        this.cc$gameTypeEffect = gameTypeEffect;
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    void onReadAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.cc$gameTypeEffect = tag.getString(Components.GAME_TYPE_EFFECT).map(name -> GameType.byName((String)name, null)).orElse(null);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    void onAddAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.cc$gameTypeEffect != null) {
            tag.putString(Components.GAME_TYPE_EFFECT, this.cc$gameTypeEffect.getName());
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    void onTick(CallbackInfo ci) {
        Location cur;
        ServerPlayer thiss = (ServerPlayer)this;
        UUID uuid = thiss.getUUID();
        if (!FreezeCommand.DATA.containsKey(uuid)) {
            return;
        }
        List<FreezeCommand.FreezeData> data = FreezeCommand.DATA.get(uuid);
        if (data.isEmpty()) {
            return;
        }
        Location dest = cur = new Location((Entity)thiss);
        for (FreezeCommand.FreezeData datum : data) {
            dest = datum.getDestination(dest);
        }
        if (!cur.level().equals(dest.level())) {
            return;
        }
        if (!cur.equals(dest)) {
            dest.teleportHere(thiss);
        }
        for (FreezeCommand.FreezeData datum : data) {
            datum.previousLocation = dest;
        }
    }

    @WrapOperation(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z")})
    private boolean restoreFromRedirectKeepInventory(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key, Operation<Boolean> original) {
        return EntityUtil.keepInventoryRedirect((Entity)this, (Boolean)original.call(new Object[]{gameRules, key}), key);
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void callDeathEvent(DamageSource source, CallbackInfo ci) {
        EntityUtil.handleDie((LivingEntity)this, source, ci);
    }

    @Inject(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void callDamageEvent(ServerLevel serverLevel, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        EntityUtil.handleDamage((Entity)this, source, amount, cir);
    }
}

