/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.crowdcontrol.common.util.TextUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.adventure.serializer.plain.PlainTextComponentSerializer;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.minecraft.network.chat.Component;

public class MojmapTextUtil
implements TextUtil {
    private final ModdedCrowdControlPlugin plugin;
    private ComponentFlattener flattener = ComponentFlattener.basic();
    private PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
    private boolean initialized = false;

    public MojmapTextUtil(@NotNull ModdedCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.plugin.adventureOptional().ifPresent(adventure -> {
            this.initialized = true;
            this.flattener = adventure.flattener();
            this.serializer = (PlainTextComponentSerializer)PlainTextComponentSerializer.builder().flattener(this.flattener).build();
        });
    }

    @Override
    @Nullable
    public ComponentFlattener flattener() {
        this.initialize();
        return this.flattener;
    }

    @Override
    @NotNull
    public PlainTextComponentSerializer serializer() {
        this.initialize();
        return this.serializer;
    }

    @NotNull
    public String asPlain(@NotNull Component component) {
        return this.asPlain((ComponentLike)this.plugin.toAdventure(component));
    }
}

