/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.neoforge.client;

import dev.qixils.crowdcontrol.plugin.fabric.client.ModdedPlatformClient;
import dev.qixils.crowdcontrol.plugin.fabric.client.neoforge.ClientPacketContextImpl;
import dev.qixils.crowdcontrol.plugin.fabric.packets.MovementStatusS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.RequestVersionS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetLanguageS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetShaderS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.neoforge.PacketUtilImpl;
import dev.qixils.relocated.annotations.NotNull;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="crowdcontrol", dist={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class NeoForgePlatformClient
extends ModdedPlatformClient {
    public NeoForgePlatformClient(ModContainer container, IEventBus modBus) {
        this.onInitializeClient();
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(cont, screen) -> NeoForgePlatformClient.createConfigScreen(screen)));
        modBus.addListener(this::register);
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        PacketUtilImpl.registerPackets(event);
        PayloadRegistrar registrar = event.registrar("1").optional();
        registrar.playToClient(SetShaderS2C.PACKET_ID, SetShaderS2C.PACKET_CODEC, (payload, context) -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer localPlayer = (LocalPlayer)patt0$temp;
            this.handleSetShader((SetShaderS2C)payload, new ClientPacketContextImpl(context, localPlayer));
        });
        registrar.playToClient(RequestVersionS2C.PACKET_ID, RequestVersionS2C.PACKET_CODEC, (payload, context) -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer localPlayer = (LocalPlayer)patt0$temp;
            this.handleRequestVersion((RequestVersionS2C)payload, new ClientPacketContextImpl(context, localPlayer));
        });
        registrar.playToClient(MovementStatusS2C.PACKET_ID, MovementStatusS2C.PACKET_CODEC, (payload, context) -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof LocalPlayer)) {
                return;
            }
            LocalPlayer localPlayer = (LocalPlayer)patt0$temp;
            this.handleMovementStatus((MovementStatusS2C)payload, new ClientPacketContextImpl(context, localPlayer));
        });
        registrar.playToClient(SetLanguageS2C.PACKET_ID, SetLanguageS2C.PACKET_CODEC, (payload, context) -> {});
    }

    @Override
    public void sendToServer(@NotNull CustomPacketPayload payload) {
        try {
            PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (UnsupportedOperationException e) {
            this.logger.debug("Server cannot receive packet {}", (Object)payload);
        }
    }
}

