/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;

public class SoftLockConfig {
    public static final int DEF_PERIOD = 120;
    public static final int DEF_DEATHS = 6;
    public static final int DEF_SEARCH_HORIZ = 20;
    public static final int DEF_SEARCH_VERT = 8;
    private final Duration period;
    private final int deaths;
    private final int searchHoriz;
    private final int searchVert;

    public SoftLockConfig() {
        this(120, 6, 20, 8);
    }

    public SoftLockConfig(Duration period, int deaths, int searchHoriz, int searchVert) {
        this.period = period;
        this.deaths = deaths;
        this.searchHoriz = searchHoriz;
        this.searchVert = searchVert;
    }

    public SoftLockConfig(int period, int deaths, int searchHoriz, int searchVert) {
        this(Duration.ofSeconds(period), deaths, searchHoriz, searchVert);
    }

    @NotNull
    public Duration getPeriod() {
        return this.period;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getSearchH() {
        return this.searchHoriz;
    }

    public int getSearchV() {
        return this.searchVert;
    }
}

