/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Locale;
import java.util.UUID;

public class UUIDUtil {
    @CheckReturnValue
    @Nullable
    public static UUID parseUUID(@NotNull String uuid) {
        if (((String)uuid).length() == 32) {
            uuid = ((String)uuid).substring(0, 8) + "-" + ((String)uuid).substring(8, 12) + "-" + ((String)uuid).substring(12, 16) + "-" + ((String)uuid).substring(16, 20) + "-" + ((String)uuid).substring(20);
        }
        try {
            return UUID.fromString((String)uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @CheckReturnValue
    @NotNull
    public static String formatUUID(UUID uuid) {
        return uuid.toString().toLowerCase(Locale.ENGLISH).replace("-", "");
    }
}

