/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class EntityChaosCommand
extends ModdedCommand {
    private static final int R = 400;
    private final String effectName = "entity_chaos";

    public EntityChaosCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            HashSet<Entity> entities = new HashSet<Entity>(200);
            if (players.stream().anyMatch(this.plugin::globalEffectsUsableFor)) {
                for (ServerLevel level : this.plugin.server().getAllLevels()) {
                    for (Entity entity : level.getAllEntities()) {
                        if (entity.getType() == EntityType.PLAYER) continue;
                        entities.add(entity);
                    }
                }
            } else {
                for (ServerPlayer player : (List)playerSupplier.get()) {
                    Vec3 pp = player.position();
                    for (Entity entity : ((ServerLevel)player.level()).getAllEntities()) {
                        if (entity.getType() == EntityType.PLAYER) continue;
                        Vec3 ep = entity.position();
                        double x = pp.x - ep.x;
                        double y = pp.y - ep.y;
                        double z = pp.z - ep.z;
                        if (!(x * x + y * y + z * z < 400.0)) continue;
                        entities.add(entity);
                    }
                }
            }
            if (entities.size() < 10) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Not enough entities found to teleport");
            }
            int i = 0;
            boolean success = false;
            for (Entity entity : entities) {
                try {
                    entity.ejectPassengers();
                    ServerPlayer target = (ServerPlayer)players.get(i++ % players.size());
                    Vec3 dest = target.position();
                    success |= entity.teleportTo(target.serverLevel(), dest.x, dest.y, dest.z, Collections.emptySet(), entity.getYRot(), entity.getXRot(), false);
                }
                catch (Exception exception) {}
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not teleport entities");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

