/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.EventListener;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;

@EventListener
public class FlightCommand
extends ModdedCommand
implements CCTimedEffect {
    private final String effectName = "flight";
    private final Duration defaultDuration = Duration.ofSeconds(15L);
    private final String effectGroup = "gamemode";
    private final List<String> effectGroups = Collections.singletonList("gamemode");
    private final Map<UUID, List<UUID>> uuidMap = new HashMap<UUID, List<UUID>>();

    public FlightCommand(@NotNull ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (ServerPlayer player : players) {
                GameType gamemode = player.gameMode.getGameModeForPlayer();
                if (gamemode == GameType.CREATIVE || gamemode == GameType.SPECTATOR) continue;
                Abilities abilities = player.getAbilities();
                if (abilities.mayfly || abilities.flying) continue;
                success = true;
                this.sync(() -> {
                    abilities.mayfly = true;
                    abilities.flying = true;
                    player.addDeltaMovement(new Vec3(0.0, 0.2, 0.0));
                    player.hurtMarked = true;
                    player.onUpdateAbilities();
                });
            }
            if (!success) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Target is already flying or able to fly");
            }
            this.uuidMap.put(request.getRequestId(), players.stream().map(Entity::getUUID).toList());
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<ServerPlayer> players = this.plugin.toPlayerList((Collection<UUID>)this.uuidMap.remove(request.getRequestId()));
        this.sync(() -> players.forEach(player -> {
            Abilities abilities = player.getAbilities();
            abilities.mayfly = false;
            abilities.flying = false;
            player.onUpdateAbilities();
        }));
    }

    @Listener
    public void onJoin(Join event) {
        ServerPlayer player = event.player();
        GameType gamemode = player.gameMode.getGameModeForPlayer();
        if (gamemode == GameType.CREATIVE) {
            return;
        }
        if (gamemode == GameType.SPECTATOR) {
            return;
        }
        Abilities abilities = player.getAbilities();
        if (!abilities.flying && !abilities.mayfly) {
            return;
        }
        abilities.mayfly = false;
        abilities.flying = false;
        player.onUpdateAbilities();
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public Map<UUID, List<UUID>> getUuidMap() {
        return this.uuidMap;
    }
}

