/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class TeleportCommand
extends ModdedCommand {
    private final String effectName = "chorus_fruit";
    private final List<String> effectGroups = List.of("walk", "look");

    public TeleportCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    private static double nextDoubleOffset() {
        double value = RandomUtil.RNG.nextDouble(3.0, 16.0);
        if (RandomUtil.RNG.nextBoolean()) {
            value = -value;
        }
        return value;
    }

    private static int nextIntOffset() {
        int value = RandomUtil.RNG.nextInt(3, 16);
        if (RandomUtil.RNG.nextBoolean()) {
            value = -value;
        }
        return value;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull ServerPlayer>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isArrayActive(ccPlayer)) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot teleport while frozen");
            }
            boolean success = false;
            block0: for (ServerPlayer player : (List)playerSupplier.get()) {
                if (player.isPassenger()) {
                    player.stopRiding();
                }
                ServerLevel level = player.serverLevel();
                double x = player.getX();
                double y = player.getY();
                double z = player.getZ();
                for (int i = 0; i < 16; ++i) {
                    double destZ;
                    double destY;
                    double destX = x + TeleportCommand.nextDoubleOffset();
                    if (!player.randomTeleport(destX, destY = Mth.clamp((double)(y + (double)TeleportCommand.nextIntOffset()), (double)level.getMinY(), (double)(level.getMinY() + level.getLogicalHeight() - 1)), destZ = z + TeleportCommand.nextDoubleOffset(), true)) continue;
                    level.playSound(null, x, y, z, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
                    success = true;
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No teleportation destinations were available");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

