/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.BufferedReader;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import live.crowdcontrol.cc4j.CCEventType;
import live.crowdcontrol.cc4j.CCMessage;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.util.CloseData;
import live.crowdcontrol.cc4j.util.EventManager;
import live.crowdcontrol.cc4j.util.HttpUtil;
import live.crowdcontrol.cc4j.util.TokenUtils;
import live.crowdcontrol.cc4j.websocket.SocketEvent;
import live.crowdcontrol.cc4j.websocket.SocketRequest;
import live.crowdcontrol.cc4j.websocket.UserToken;
import live.crowdcontrol.cc4j.websocket.data.CCEffectReport;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CallData;
import live.crowdcontrol.cc4j.websocket.data.CallDataMethod;
import live.crowdcontrol.cc4j.websocket.data.GenerateAuthCodeData;
import live.crowdcontrol.cc4j.websocket.data.IdentifierType;
import live.crowdcontrol.cc4j.websocket.data.RemoteProcedureCallData;
import live.crowdcontrol.cc4j.websocket.data.ReportStatus;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.data.SubscriptionData;
import live.crowdcontrol.cc4j.websocket.http.AuthApplicationTokenData;
import live.crowdcontrol.cc4j.websocket.http.AuthApplicationTokenPayload;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectsOperation;
import live.crowdcontrol.cc4j.websocket.http.GamePack;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStartData;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStartPayload;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStopData;
import live.crowdcontrol.cc4j.websocket.http.GameSessionStopPayload;
import live.crowdcontrol.cc4j.websocket.http.PutCustomEffectsData;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodeErrorPayload;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodePayload;
import live.crowdcontrol.cc4j.websocket.payload.ApplicationAuthCodeRedeemedPayload;
import live.crowdcontrol.cc4j.websocket.payload.CCBaseEffectDescription;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import live.crowdcontrol.cc4j.websocket.payload.SubscriptionResultPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class ConnectedPlayer
implements CCPlayer,
WebSocket.Listener {
    @NotNull
    public static final ObjectMapper JACKSON;
    @NotNull
    protected static final Logger log;
    protected final ReentrantLock lock = new ReentrantLock();
    @NotNull
    protected final Set<String> subscriptions = new HashSet<String>();
    protected final Map<String, Boolean> visible = new HashMap<String, Boolean>();
    protected final Map<String, Boolean> available = new HashMap<String, Boolean>();
    @NotNull
    protected final EventManager eventManager;
    @NotNull
    protected final UUID uuid;
    @NotNull
    protected final Path tokenPath;
    @NotNull
    protected final CrowdControl parent;
    @NotNull
    protected StringBuilder pendingText = new StringBuilder();
    @Nullable
    protected WebSocket ws;
    @Nullable
    protected String authCode;
    @Nullable
    protected String token;
    @Nullable
    protected UserToken userToken;
    @Nullable
    protected String gameSessionID;
    @Nullable
    protected String lastGameSessionID;
    @Nullable
    protected CompletableFuture<Void> pendingAuthCode;
    protected int sleep = 1;
    protected long disconnectTriggeredAt = 0L;
    protected ScheduledFuture<?> keepAlive = null;
    protected ScheduledFuture<?> timeout = null;

    public ConnectedPlayer(@NotNull UUID uuid, @NotNull CrowdControl parent) {
        this.parent = parent;
        this.uuid = uuid;
        this.tokenPath = parent.getDataFolder().resolve(String.valueOf(uuid) + ".token");
        this.eventManager = new EventManager(parent);
        this.eventManager.registerEventConsumer(CCEventType.CONNECTED, handshake -> {
            this.sleep = 1;
            long wait = 1L;
            while (!this.canSend() && wait <= 10L) {
                try {
                    Thread.sleep(wait * 500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    wait *= 2L;
                }
            }
            if (!this.canSend()) {
                log.warn("Socket is not opening, session start may fail");
            }
            this.subscribe();
            this.regenerateAuthCode();
            this.resetKeepAlive();
        });
        this.eventManager.registerEventConsumer(CCEventType.DISCONNECTED, data -> {
            if (this.timeout != null) {
                this.timeout.cancel(false);
                this.timeout = null;
            }
            this.ws = null;
            if (this.parent.getPlayer(uuid) != this) {
                return;
            }
            this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.WARN, "Reconnecting to socket in " + this.sleep + " second(s)"));
            try {
                Thread.sleep((long)this.sleep * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sleep *= 2;
            this.connect();
        });
        this.eventManager.registerEventConsumer(CCEventType.GENERATED_AUTH_CODE, payload -> {
            if (this.timeout != null) {
                this.timeout.cancel(false);
                this.timeout = null;
            }
            this.authCode = payload.code();
            if (this.pendingAuthCode != null) {
                this.pendingAuthCode.complete(null);
                this.pendingAuthCode = null;
            }
        });
        this.eventManager.registerEventConsumer(CCEventType.REDEEMED_AUTH_CODE, payload -> parent.getHttpUtil().apiPost("/auth/application/token", AuthApplicationTokenPayload.class, null, (Object)new AuthApplicationTokenData(parent.getAppID(), payload.code(), parent.getAppSecret())).handle((tokenPayload, e) -> {
            if (e != null) {
                log.warn("Failed to query URL", e);
                this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.ERROR, "Failed to authenticate account"));
                return null;
            }
            if (tokenPayload == null || tokenPayload.token() == null) {
                log.warn("Failed to read token");
                this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.ERROR, "Failed to verify account"));
                return null;
            }
            this.authCode = null;
            this.setToken(tokenPayload.token());
            this.saveToken();
            return null;
        }));
        this.eventManager.registerEventConsumer(CCEventType.ERRORED_AUTH_CODE, payload -> {
            log.warn("Failed to redeem auth code for reason {}, generating new one", (Object)payload.message());
            this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.ERROR, "Failed to redeem auth code"));
            this.send(new SocketRequest(GenerateAuthCodeData.ACTION, new GenerateAuthCodeData(parent.getAppID())));
        });
        this.eventManager.registerEventRunnable(CCEventType.AUTHENTICATED, this::subscribe);
        this.eventManager.registerEventConsumer(CCEventType.SUBSCRIBED, payload -> {
            if (this.timeout != null) {
                this.timeout.cancel(false);
                this.timeout = null;
            }
            assert (this.userToken != null) : "Subscribed before authenticating";
            this.subscriptions.addAll(payload.getSuccess());
        });
        this.eventManager.registerEventConsumer(CCEventType.EFFECT_REQUEST, payload -> this.parent.executeEffect((PublicEffectPayload)payload, this));
        this.eventManager.registerEventConsumer(CCEventType.EFFECT_FAILURE, payload -> parent.cancelByRequestId(payload.getRequestId()));
        this.loadToken();
    }

    private void emitDisconnect(CloseData data) {
        long now = System.currentTimeMillis();
        if (now - this.disconnectTriggeredAt <= 900L) {
            return;
        }
        this.disconnectTriggeredAt = now;
        this.eventManager.dispatch(CCEventType.DISCONNECTED, data);
    }

    public void connect() {
        log.info("Connecting WebSocket");
        this.timeout = this.parent.getTimedEffectPool().schedule(() -> {
            this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.WARN, "Failed to initiate socket connection"));
            this.close();
        }, 60L, TimeUnit.SECONDS);
        HttpUtil.HTTP_CLIENT.newWebSocketBuilder().buildAsync(URI.create("wss://pubsub.crowdcontrol.live/"), this).thenAccept(ws -> {
            this.ws = ws;
        });
    }

    public CompletableFuture<?> close() {
        if (!this.canSend()) {
            return CompletableFuture.completedFuture(null);
        }
        assert (this.ws != null);
        return this.ws.sendClose(1000, "").whenComplete(($1, $2) -> this.emitDisconnect(new CloseData(1000, null, false)));
    }

    public void clearKeepAlive() {
        if (this.keepAlive == null) {
            return;
        }
        this.keepAlive.cancel(false);
        this.keepAlive = null;
    }

    public void resetKeepAlive() {
        if (!this.canSend()) {
            return;
        }
        assert (this.ws != null);
        this.clearKeepAlive();
        this.keepAlive = this.parent.getTimedEffectPool().schedule(() -> {
            log.info("KeepAlive failed, reconnecting");
            this.clearKeepAlive();
            this.close();
        }, 15L, TimeUnit.SECONDS);
        this.ws.sendPing(ByteBuffer.allocate(0));
    }

    @Override
    public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        this.resetKeepAlive();
        return null;
    }

    @Override
    public void onOpen(WebSocket ws) {
        this.eventManager.dispatch(CCEventType.CONNECTED);
        ws.request(Long.MAX_VALUE);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.pendingText.append(data);
        if (!last) {
            return null;
        }
        try {
            String message = this.pendingText.toString();
            this.pendingText = new StringBuilder();
            SocketEvent event = (SocketEvent)JACKSON.readValue(message, SocketEvent.class);
            switch (event.type) {
                case "application-auth-code": {
                    this.eventManager.dispatch(CCEventType.GENERATED_AUTH_CODE, (ApplicationAuthCodePayload)JACKSON.treeToValue((TreeNode)event.payload, ApplicationAuthCodePayload.class));
                    break;
                }
                case "application-auth-code-error": {
                    this.eventManager.dispatch(CCEventType.ERRORED_AUTH_CODE, (ApplicationAuthCodeErrorPayload)JACKSON.treeToValue((TreeNode)event.payload, ApplicationAuthCodeErrorPayload.class));
                    break;
                }
                case "application-auth-code-redeemed": {
                    this.eventManager.dispatch(CCEventType.REDEEMED_AUTH_CODE, (ApplicationAuthCodeRedeemedPayload)JACKSON.treeToValue((TreeNode)event.payload, ApplicationAuthCodeRedeemedPayload.class));
                    break;
                }
                case "subscription-result": {
                    SubscriptionResultPayload subscriptionPayload = (SubscriptionResultPayload)JACKSON.treeToValue((TreeNode)event.payload, SubscriptionResultPayload.class);
                    if (subscriptionPayload == null) break;
                    subscriptionPayload = new SubscriptionResultPayload(subscriptionPayload.getSuccess().stream().filter(Objects::nonNull).collect(Collectors.toSet()), subscriptionPayload.getFailure().stream().filter(Objects::nonNull).collect(Collectors.toSet()));
                    this.eventManager.dispatch(CCEventType.SUBSCRIBED, subscriptionPayload);
                    break;
                }
                case "effect-request": {
                    if (!event.domain.equals("pub")) {
                        return null;
                    }
                    PublicEffectPayload requestPayload = (PublicEffectPayload)JACKSON.treeToValue((TreeNode)event.payload, PublicEffectPayload.class);
                    if (!"game".equals(requestPayload.getEffect().getType())) {
                        return null;
                    }
                    this.eventManager.dispatch(CCEventType.EFFECT_REQUEST, requestPayload);
                    break;
                }
                case "effect-failure": {
                    if (!event.domain.equals("pub")) {
                        return null;
                    }
                    PublicEffectPayload failurePayload = (PublicEffectPayload)JACKSON.treeToValue((TreeNode)event.payload, PublicEffectPayload.class);
                    if (!"game".equals(failurePayload.getEffect().getType())) {
                        return null;
                    }
                    this.eventManager.dispatch(CCEventType.EFFECT_FAILURE, failurePayload);
                    break;
                }
                case "game-session-start": {
                    break;
                }
                case "game-session-stop": {
                    break;
                }
                default: {
                    log.debug("Ignoring unknown event {} on domain {}", (Object)event.type, (Object)event.domain);
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to handle incoming message {}", (Object)data, (Object)e);
        }
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.emitDisconnect(new CloseData(statusCode, reason, true));
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        log.error("An unknown WebSocket error has occurred", error);
        this.eventManager.dispatch(CCEventType.MESSAGE, new CCMessage(CCMessage.Level.WARN, "An unknown socket error occurred"));
    }

    public boolean canSend() {
        return this.ws != null && !this.ws.isOutputClosed();
    }

    public boolean canSendRPC() {
        return this.canSend() && this.token != null;
    }

    @NotNull
    private CompletableFuture<String> send(SocketRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String message;
            try {
                message = JACKSON.writeValueAsString((Object)request);
            }
            catch (JsonProcessingException e2) {
                throw new IllegalArgumentException("Could not encode message", e2);
            }
            this.lock.lock();
            try {
                if (!this.canSend()) {
                    throw new IllegalStateException("Attempted to send message before connecting " + message.substring(0, 20));
                }
                assert (this.ws != null);
                String string = (String)((CompletableFuture)this.ws.sendText(message, true).handleAsync(($, e) -> {
                    if (e != null) {
                        throw new IllegalStateException("WebSocket failed to send message " + message.substring(0, 20), (Throwable)e);
                    }
                    return message;
                })).join();
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }).whenComplete((message, e) -> {
            if (e != null) {
                log.warn("Failed to send message", e);
            }
        });
    }

    public CompletableFuture<Boolean> sendRPC(CallData<?> call) {
        if (!this.canSendRPC()) {
            return CompletableFuture.completedFuture(false);
        }
        assert (this.token != null);
        return this.send(new SocketRequest("rpc", new RemoteProcedureCallData(this.token, call))).handle(($, e) -> e == null);
    }

    @Override
    public CompletableFuture<Boolean> sendResponse(@NotNull CCEffectResponse response) {
        if (response == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (response.getStatus() == ResponseStatus.DELAY_ESTIMATED) {
            return CompletableFuture.completedFuture(false);
        }
        this.eventManager.dispatch(CCEventType.EFFECT_RESPONSE, response);
        return this.sendRPC(new CallData<CCEffectResponse>(CallDataMethod.EFFECT_RESPONSE, Collections.singletonList(response)));
    }

    @Override
    @NotNull
    public CompletableFuture<?> regenerateAuthCode() {
        if (this.token != null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.pendingAuthCode != null) {
            if (this.pendingAuthCode.isDone()) {
                this.pendingAuthCode = null;
            } else {
                return this.pendingAuthCode;
            }
        }
        this.pendingAuthCode = new CompletableFuture().orTimeout(10L, TimeUnit.SECONDS).handle((unused, throwable) -> null);
        this.send(new SocketRequest(GenerateAuthCodeData.ACTION, new GenerateAuthCodeData(this.parent.getAppID(), List.of("profile:read", "session:write", "session:control", "custom-effects:write"), List.of(this.parent.getGamePackID()), false)));
        return this.pendingAuthCode;
    }

    private List<CCEffectReport> filterReports(boolean force, CCEffectReport ... reports) {
        return Stream.of(reports).map(report -> {
            List<String> ids;
            IdentifierType idType = switch (report.getIdentifierType()) {
                case IdentifierType.CATEGORY, IdentifierType.GROUP -> {
                    List newIds;
                    Map<String, CCBaseEffectDescription> effects;
                    GamePack gamePack = this.parent.getGamePack();
                    if (gamePack != null && (effects = gamePack.getEffects().getGame()) != null && !(newIds = effects.entrySet().stream().filter(entry -> {
                        List<String> values;
                        CCBaseEffectDescription effect = (CCBaseEffectDescription)entry.getValue();
                        List<String> list = values = report.getIdentifierType() == IdentifierType.CATEGORY ? effect.getCategories() : effect.getGroups();
                        if (values == null) {
                            return false;
                        }
                        return report.getIds().stream().anyMatch(values::contains);
                    }).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                        ids = newIds;
                        yield IdentifierType.EFFECT;
                    }
                }
                default -> {
                    ids = report.getIds();
                    yield report.getIdentifierType();
                }
            };
            int idSize = ids.size();
            ReportStatus status = report.getStatus();
            Boolean value = status == ReportStatus.MENU_AVAILABLE || status == ReportStatus.MENU_VISIBLE;
            Map<String, Boolean> map = status == ReportStatus.MENU_AVAILABLE || status == ReportStatus.MENU_UNAVAILABLE ? this.available : this.visible;
            ids = ids.stream().filter(id -> map.put(idType.getValue() + ":" + id, value) != value || force).collect(Collectors.toList());
            if (ids.size() == idSize) {
                return report;
            }
            return new CCEffectReport(idType, status, ids);
        }).filter(report -> !report.getIds().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Boolean> sendReport(CCEffectReport ... reports) {
        if (!this.canSendRPC()) {
            return CompletableFuture.completedFuture(false);
        }
        List<CCEffectReport> reportList = this.filterReports(false, reports);
        if (reportList.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.sendRPC(new CallData<CCEffectReport>(CallDataMethod.EFFECT_REPORT, reportList));
    }

    @Override
    @NotNull
    public CompletableFuture<?> setCustomEffects(@NotNull List<CustomEffectsOperation> operations) {
        if (this.token == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.userToken == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.userToken.getApp() == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (!this.userToken.getApp().scopes().contains("custom-effects:write")) {
            return CompletableFuture.completedFuture(null);
        }
        return this.parent.getHttpUtil().apiPut("/menu/custom-effects", this.token, new PutCustomEffectsData(this.parent.getGamePackID(), operations)).handle((payload, e) -> {
            if (e != null) {
                log.warn("Failed to put custom effects", e);
                return null;
            }
            return null;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<?> startSession(CCEffectReport ... reports) {
        if (this.gameSessionID != null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.token == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.parent.getHttpUtil().apiPost("/game-session/start", GameSessionStartPayload.class, this.token, (Object)new GameSessionStartData(this.parent.getGamePackID(), this.filterReports(true, reports))).handle((payload, e) -> {
            if (e != null) {
                log.warn("Failed to query URL", e);
                return null;
            }
            if (payload == null) {
                log.warn("Got bad payload");
                return null;
            }
            this.gameSessionID = payload.getGameSessionId();
            if (this.lastGameSessionID != null && !this.gameSessionID.equals(this.lastGameSessionID)) {
                this.visible.clear();
                this.available.clear();
                this.filterReports(true, reports);
            }
            this.lastGameSessionID = this.gameSessionID;
            this.eventManager.dispatch(CCEventType.SESSION_STARTED, payload);
            return null;
        });
    }

    @Override
    @NotNull
    public CompletableFuture<?> stopSession() {
        this.setCustomEffects(Collections.singletonList(new CustomEffectsOperation("replace-all", Collections.emptyMap())));
        if (this.gameSessionID == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.token == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.parent.getHttpUtil().apiPost("/game-session/stop", GameSessionStopPayload.class, this.token, (Object)new GameSessionStopData(this.gameSessionID)).handle((payload, e) -> {
            if (e != null) {
                log.warn("Failed to query URL", e);
                return null;
            }
            this.gameSessionID = null;
            this.eventManager.dispatch(CCEventType.SESSION_STOPPED, payload);
            return null;
        });
    }

    public boolean setToken(String token) {
        String[] split = token.split(" ");
        if (split.length > 2) {
            log.warn("Invalid token length {} for {}", (Object)split.length, (Object)token);
            return false;
        }
        if (split.length == 2) {
            if (!Objects.equals(split[0], "cc-auth-token")) {
                log.warn("Unknown auth token type {} for {}", (Object)split[0], (Object)token);
                return false;
            }
            token = split[1];
        }
        try {
            this.userToken = (UserToken)JACKSON.readValue(TokenUtils.decodePayload(token), UserToken.class);
            if (Instant.ofEpochSecond(this.userToken.getExp()).minus(6L, ChronoUnit.HOURS).isBefore(Instant.now())) {
                log.warn("User {}'s auth token has expired", (Object)this.uuid);
                this.userToken = null;
                this.eventManager.dispatch(CCEventType.AUTH_EXPIRED);
                this.eventManager.dispatch(CCEventType.UNAUTHENTICATED);
                return false;
            }
        }
        catch (Exception e) {
            log.warn("Failed to set token {}", (Object)token, (Object)e);
            return false;
        }
        this.token = token;
        this.eventManager.dispatch(CCEventType.AUTHENTICATED);
        return true;
    }

    protected boolean loadToken() {
        boolean bl;
        block9: {
            if (!Files.exists(this.tokenPath, new LinkOption[0])) {
                return false;
            }
            BufferedReader reader = Files.newBufferedReader(this.tokenPath);
            try {
                bl = this.setToken(reader.readLine());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Failed to read user {} token", (Object)this.uuid, (Object)e);
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    protected void saveToken() {
        try {
            if (this.token == null) {
                Files.deleteIfExists(this.tokenPath);
            } else {
                Files.writeString(this.tokenPath, (CharSequence)this.token, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            log.warn("Failed to write user {} token", (Object)this.uuid, (Object)e);
        }
    }

    protected void subscribe() {
        if (!this.canSendRPC()) {
            return;
        }
        assert (this.userToken != null);
        HashSet<CallSite> subscribeTo = new HashSet<CallSite>(Set.of("pub/" + this.userToken.getId()));
        subscribeTo.removeAll(this.subscriptions);
        if (subscribeTo.isEmpty()) {
            return;
        }
        this.send(new SocketRequest("subscribe", new SubscriptionData(subscribeTo, this.token)));
    }

    @Override
    @Nullable
    public String getAuthUrl() {
        if (this.authCode == null) {
            return null;
        }
        return String.format("https://auth.crowdcontrol.live/code/%s?showAllPlatforms=true", this.authCode);
    }

    @Override
    public void clearToken() {
        this.token = null;
        this.userToken = null;
        this.saveToken();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    @Nullable
    public String getAuthCode() {
        return this.authCode;
    }

    @Override
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public UserToken getUserToken() {
        return this.userToken;
    }

    @Override
    @NotNull
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    @Nullable
    public String getGameSessionId() {
        return this.gameSessionID;
    }

    static {
        log = LoggerFactory.getLogger((String)"CrowdControl/ConnectedPlayer");
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("CrowdControlSerializers");
        module.addDeserializer(CCName.class, (JsonDeserializer)new CCName.CCNameAdapter());
        module.addDeserializer(CustomEffectDuration.class, (JsonDeserializer)new CustomEffectDuration.CustomEffectDurationAdapter());
        mapper.registerModule((Module)module);
        JACKSON = mapper;
    }
}

