/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.exceptions.ExceptionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class LimitConfig {
    private final boolean hostsBypass;
    @NotNull
    private final Map<String, Integer> itemLimits;
    private final int itemDefaultLimit;
    @NotNull
    private final Map<String, Integer> entityLimits;
    private final int entityDefaultLimit;

    public LimitConfig(boolean hostsBypass, @Nullable Map<String, Integer> itemLimits, @Nullable Map<String, Integer> entityLimits) {
        this.hostsBypass = hostsBypass;
        this.itemLimits = new HashMap<String, Integer>(ExceptionUtil.validateNotNullElseGet(itemLimits, Collections::emptyMap));
        this.itemDefaultLimit = this.itemLimits.getOrDefault("default", 0);
        this.entityLimits = new HashMap<String, Integer>(ExceptionUtil.validateNotNullElseGet(entityLimits, Collections::emptyMap));
        this.entityDefaultLimit = this.entityLimits.getOrDefault("default", 0);
    }

    public LimitConfig() {
        this(true, null, null);
    }

    public boolean hostsBypass() {
        return this.hostsBypass;
    }

    public int getItemLimit(@NotNull String item) {
        return this.itemLimits.getOrDefault(item, this.itemDefaultLimit);
    }

    @NotNull
    public Map<String, Integer> itemLimits() {
        return Collections.unmodifiableMap(this.itemLimits);
    }

    public int getEntityLimit(@NotNull String entity) {
        return this.entityLimits.getOrDefault(entity, this.entityDefaultLimit);
    }

    @NotNull
    public Map<String, Integer> entityLimits() {
        return Collections.unmodifiableMap(this.entityLimits);
    }

    public String toString() {
        return "LimitConfig{hostsBypass=" + this.hostsBypass + ", itemLimits=" + String.valueOf(this.itemLimits) + ", itemDefaultLimit=" + this.itemDefaultLimit + ", entityLimits=" + String.valueOf(this.entityLimits) + ", entityDefaultLimit=" + this.entityDefaultLimit + "}";
    }
}

