/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.command.impl.HalfHealthCommand;
import dev.qixils.crowdcontrol.common.command.impl.HealthModifierCommand;
import dev.qixils.crowdcontrol.common.command.impl.exp.ExpAddCommand;
import dev.qixils.crowdcontrol.common.command.impl.exp.ExpSubCommand;
import dev.qixils.crowdcontrol.common.command.impl.exp.ResetExpCommand;
import dev.qixils.crowdcontrol.common.command.impl.food.FoodAddCommand;
import dev.qixils.crowdcontrol.common.command.impl.food.FoodSubCommand;
import dev.qixils.crowdcontrol.common.command.impl.food.FullFeedCommand;
import dev.qixils.crowdcontrol.common.command.impl.food.FullStarveCommand;
import dev.qixils.crowdcontrol.common.command.impl.health.DamageCommand;
import dev.qixils.crowdcontrol.common.command.impl.health.FullHealCommand;
import dev.qixils.crowdcontrol.common.command.impl.health.HealCommand;
import dev.qixils.crowdcontrol.common.command.impl.health.KillCommand;
import dev.qixils.crowdcontrol.common.command.impl.maxhealth.MaxHealthAddCommand;
import dev.qixils.crowdcontrol.common.command.impl.maxhealth.MaxHealthCommand;
import dev.qixils.crowdcontrol.common.command.impl.maxhealth.MaxHealthSubCommand;
import dev.qixils.crowdcontrol.common.util.CollectionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.MonotonicNonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public abstract class AbstractCommandRegister<PLAYER, PLUGIN extends Plugin<PLAYER, ?>> {
    @NotNull
    protected final PLUGIN plugin;
    @NotNull
    protected final Set<Class<? extends Command<PLAYER>>> registeredCommandClasses = new HashSet<Class<? extends Command<PLAYER>>>();
    @NotNull
    protected final Map<Class<? extends Command<PLAYER>>, Command<PLAYER>> singleCommandInstances = new HashMap<Class<? extends Command<PLAYER>>, Command<PLAYER>>();
    protected final @NotNull Map<@Nullable String, Command<PLAYER>> registeredCommandMap = new HashMap<String, Command<PLAYER>>();
    @NotNull
    protected final @NotNull Map<@NotNull String, @NotNull List<@NotNull String>> effectGroupMap = new HashMap<String, List<String>>();
    protected @MonotonicNonNull List<Command<PLAYER>> registeredCommands;

    protected AbstractCommandRegister(@NotNull PLUGIN plugin) {
        this.plugin = plugin;
    }

    @SafeVarargs
    @NotNull
    protected final <T> Collection<T> initAll(Supplier<? extends T> ... suppliers) {
        ArrayList collection = new ArrayList(suppliers.length);
        for (Supplier<? extends T> supplier : suppliers) {
            CollectionUtil.initTo(collection, supplier);
        }
        return collection;
    }

    protected void createCommands(List<Command<PLAYER>> commands) {
        commands.addAll(this.initAll(() -> new HalfHealthCommand(this.plugin), () -> new MaxHealthSubCommand(this.plugin), () -> new MaxHealthAddCommand(this.plugin), () -> new MaxHealthCommand(this.plugin, 4), () -> new KillCommand(this.plugin), () -> new DamageCommand(this.plugin), () -> new FullHealCommand(this.plugin), () -> new HealCommand(this.plugin), () -> new FoodAddCommand(this.plugin), () -> new FoodSubCommand(this.plugin), () -> new FullFeedCommand(this.plugin), () -> new FullStarveCommand(this.plugin), () -> new ExpAddCommand(this.plugin), () -> new ExpSubCommand(this.plugin), () -> new ResetExpCommand(this.plugin)));
        for (HealthModifierCommand.Modifier modifier : HealthModifierCommand.Modifier.values()) {
            CollectionUtil.initTo(commands, () -> new HealthModifierCommand(this.plugin, modifier));
        }
    }

    public final synchronized List<Command<PLAYER>> getCommands() {
        if (this.registeredCommands != null) {
            return this.registeredCommands;
        }
        if (!this.isReady()) {
            return Collections.emptyList();
        }
        ArrayList<Command<PLAYER>> commands = new ArrayList<Command<PLAYER>>();
        this.createCommands(commands);
        for (Command command : commands) {
            String effectName = command.getEffectName().toLowerCase(Locale.ENGLISH);
            this.registeredCommandMap.put(effectName, command);
            for (String effectGroup : command.getEffectGroups()) {
                this.effectGroupMap.computeIfAbsent(effectGroup, $ -> new ArrayList()).add(effectName);
            }
            Class<?> clazz = command.getClass();
            if (this.registeredCommandClasses.contains(clazz)) {
                this.singleCommandInstances.remove(clazz);
            } else {
                this.singleCommandInstances.put(clazz, command);
            }
            this.registeredCommandClasses.add(clazz);
        }
        this.registeredCommands = commands;
        for (Command command : commands) {
            String name = command.getEffectName().toLowerCase(Locale.ENGLISH);
            ((Plugin)this.plugin).registerCommand(name, command);
            if (!command.isEventListener()) continue;
            this.registerListener(command);
        }
        this.onFirstRegistry();
        return commands;
    }

    public final <C extends Command<PLAYER>> List<? extends C> getCommands(Class<C> clazz) {
        ArrayList<Command<PLAYER>> commands = new ArrayList<Command<PLAYER>>();
        for (Command<PLAYER> command : this.getCommands()) {
            if (!clazz.isInstance(command)) continue;
            commands.add(command);
        }
        return commands;
    }

    protected abstract void onFirstRegistry();

    protected abstract void registerListener(Command<PLAYER> var1);

    public boolean isReady() {
        return true;
    }

    @Deprecated
    public final void register() {
        this.getCommands();
    }

    @NotNull
    public final <T extends Command<PLAYER>> T getCommand(@NotNull Class<T> tClass) throws IllegalArgumentException {
        if (!this.singleCommandInstances.containsKey(tClass)) {
            throw new IllegalArgumentException("Requested class " + tClass.getName() + " is invalid. Please ensure that only one instance of this command is registered.");
        }
        return (T)this.singleCommandInstances.get(tClass);
    }

    @NotNull
    public final Command<PLAYER> getCommandByName(@Nullable String name) throws IllegalArgumentException {
        if (name != null) {
            name = name.toLowerCase(Locale.ENGLISH);
        }
        if (!this.registeredCommandMap.containsKey(name)) {
            throw new IllegalArgumentException("Could not find a command by the name of " + name);
        }
        return this.registeredCommandMap.get(name);
    }

    @NotNull
    public final <T extends Command<PLAYER>> T getCommandByName(@NotNull String name, @NotNull Class<T> expectedClass) throws IllegalArgumentException {
        Command<PLAYER> command = this.getCommandByName(name);
        if (!expectedClass.isInstance(command)) {
            throw new IllegalArgumentException("Expected command '" + name + "' to an instance of " + expectedClass.getSimpleName() + ", not " + command.getClass().getSimpleName());
        }
        return (T)command;
    }

    public final List<String> getEffectsByGroup(@NotNull String effectGroup) {
        return Collections.unmodifiableList(this.effectGroupMap.getOrDefault(effectGroup, Collections.emptyList()));
    }
}

