/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtil.class);

    @Nullable
    public static <T> T init(@NotNull Supplier<T> supplier, @Nullable Consumer<Exception> onError) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            if (onError != null) {
                try {
                    onError.accept(e);
                }
                catch (Exception e2) {
                    log.error("Failed to initialize {}...", (Object)supplier.getClass().getName(), (Object)e);
                    log.error("...and failed to call onError", e2);
                }
            } else {
                log.error("Failed to initialize {}", (Object)supplier.getClass().getName(), (Object)e);
            }
            return null;
        }
    }

    @Nullable
    public static <T> T init(@NotNull Supplier<T> supplier) {
        return CollectionUtil.init(supplier, null);
    }

    public static <T> void initTo(@NotNull Collection<T> collection, @NotNull Supplier<? extends T> supplier, @Nullable Consumer<Exception> onError) {
        T t = CollectionUtil.init(supplier, onError);
        if (t != null) {
            collection.add(t);
        }
    }

    public static <T> void initTo(@NotNull Collection<T> collection, @NotNull Supplier<? extends T> supplier) {
        CollectionUtil.initTo(collection, supplier, null);
    }
}

