/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class DigCommand
extends RegionalCommandSync {
    private final String effectName = "dig";

    public DigCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) not standing on any blocks");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Location playerLocation = player.getLocation();
        boolean success = false;
        for (double x = -0.5; x <= 0.5; x += 1.0) {
            for (int y = CommandConstants.getDigDepth(); y <= 0; ++y) {
                for (double z = -0.5; z <= 0.5; z += 1.0) {
                    Location block = playerLocation.clone().add(x, (double)y, z);
                    if (block.getBlock().isEmpty()) continue;
                    block.getBlock().setType(Material.AIR);
                    success = true;
                }
            }
        }
        return success;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

