/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EntitySizeCommand
extends PaperCommand {
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    private final String effectName;
    private final double level;
    private static final double radius = Math.pow(30.0, 2.0);

    public EntitySizeCommand(PaperCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            Set locations = players.stream().map(OfflinePlayer::getLocation).collect(Collectors.toSet());
            boolean success = false;
            for (World world : Bukkit.getServer().getWorlds()) {
                block1: for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (entity instanceof Player) continue;
                    Location entityLoc = entity.getLocation();
                    for (Location loc : locations) {
                        if (!Objects.equals(loc.getWorld(), entityLoc.getWorld()) || loc.distanceSquared(entityLoc) > radius || AttributeUtil.getModifier((Attributable)living, Attribute.SCALE, CommandConstants.SCALE_MODIFIER_UUID).map(AttributeModifier::getAmount).orElse(0.0) == this.level) continue;
                        entity.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> AttributeUtil.addModifier((Attributable)living, Attribute.SCALE, CommandConstants.SCALE_MODIFIER_UUID, "scale-cc", this.level, AttributeModifier.Operation.ADD_SCALAR, true), null);
                        success = true;
                        continue block1;
                    }
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find entities to resize");
        }, this.plugin.getSyncExecutor()));
    }

    public static EntitySizeCommand increase(PaperCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_double", 1.0);
    }

    public static EntitySizeCommand decrease(PaperCrowdControlPlugin plugin) {
        return new EntitySizeCommand(plugin, "entity_size_halve", -0.5);
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getLevel() {
        return this.level;
    }
}

