/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FlingCommand
extends RegionalCommandSync {
    @NotNull
    private final String effectName = "fling";

    public FlingCommand(@NotNull PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @NotNull
    private static Vector randomVector() {
        double[] vector = CommandConstants.randomFlingVector();
        return new Vector(vector[0], vector[1], vector[2]);
    }

    @Override
    @Nullable
    protected CCEffectResponse precheck(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (this.isActive(ccPlayer, "walk", "look")) {
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot fling while frozen");
        }
        return null;
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (player.isInsideVehicle()) {
            return false;
        }
        player.setVelocity(FlingCommand.randomVector());
        return true;
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot fling while inside vehicle");
    }

    @Override
    @NotNull
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

