/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.AttributeUtil;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerSizeCommand
extends PaperCommand
implements CCTimedEffect {
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    private final String effectName;
    private final double level;
    private final Map<UUID, List<UUID>> idMap = new HashMap<UUID, List<UUID>>();
    private final String effectGroup = "player_size";
    private final List<String> effectGroups = Collections.singletonList("player_size");

    public PlayerSizeCommand(PaperCrowdControlPlugin plugin, String effectName, double level) {
        super(plugin);
        this.effectName = effectName;
        this.level = level;
    }

    @Override
    public void execute(@NotNull Supplier<List<Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, "freeze", "player_size")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            for (Player player : players) {
                player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
                    AttributeUtil.addModifier((Attributable)player, Attribute.SCALE, CommandConstants.SCALE_MODIFIER_UUID, "scale-cc", this.level, AttributeModifier.Operation.ADD_SCALAR, false);
                    AttributeUtil.addModifier((Attributable)player, Attribute.STEP_HEIGHT, CommandConstants.SCALE_STEP_MODIFIER_UUID, "scale-step-cc", this.level, AttributeModifier.Operation.ADD_SCALAR, false);
                    AttributeUtil.addModifier((Attributable)player, Attribute.JUMP_STRENGTH, CommandConstants.SCALE_JUMP_MODIFIER_UUID, "scale-jump-cc", this.level, AttributeModifier.Operation.ADD_SCALAR, false);
                    AttributeUtil.addModifier((Attributable)player, Attribute.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID, "fall-cc", this.level, AttributeModifier.Operation.ADD_SCALAR, false);
                }, null);
            }
            this.idMap.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        for (Player player : PaperUtil.toPlayers(this.idMap.remove(request.getRequestId()))) {
            player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
                AttributeUtil.removeModifier((Attributable)player, Attribute.SCALE, CommandConstants.SCALE_MODIFIER_UUID);
                AttributeUtil.removeModifier((Attributable)player, Attribute.STEP_HEIGHT, CommandConstants.SCALE_STEP_MODIFIER_UUID);
                AttributeUtil.removeModifier((Attributable)player, Attribute.JUMP_STRENGTH, CommandConstants.SCALE_JUMP_MODIFIER_UUID);
                AttributeUtil.removeModifier((Attributable)player, Attribute.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID);
            }, null);
        }
    }

    public static PlayerSizeCommand increase(PaperCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_double", 1.0);
    }

    public static PlayerSizeCommand decrease(PaperCrowdControlPlugin plugin) {
        return new PlayerSizeCommand(plugin, "player_size_halve", -0.5);
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public double getLevel() {
        return this.level;
    }

    @Generated
    public Map<UUID, List<UUID>> getIdMap() {
        return this.idMap;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

