/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.bukkit.parser;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.bukkit.BukkitCaptionKeys;
import dev.qixils.relocated.cloud.caption.CaptionVariable;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.ParserException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ArgumentParser;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.World;

public final class WorldParser<C>
implements ArgumentParser<C, World>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, World> worldParser() {
        return ParserDescriptor.of(new WorldParser<C>(), World.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, World> worldComponent() {
        return CommandComponent.builder().parser(WorldParser.worldParser());
    }

    @Override
    public @NonNull ArgumentParseResult<World> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        World world = Bukkit.getWorld((String)input);
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParseException(input, commandContext));
        }
        return ArgumentParseResult.success(world);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return Bukkit.getWorlds().stream().map(World::getName).collect(Collectors.toList());
    }

    public static final class WorldParseException
    extends ParserException {
        private final String input;

        public WorldParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(WorldParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

