/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.mc;

import dev.qixils.crowdcontrol.common.mc.CCLivingEntity;
import dev.qixils.crowdcontrol.plugin.fabric.mc.FabricEntity;
import dev.qixils.crowdcontrol.plugin.fabric.utils.AttributeUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class FabricLivingEntity
extends FabricEntity
implements CCLivingEntity {
    public FabricLivingEntity(LivingEntity entity) {
        super((Entity)entity);
    }

    @NotNull
    public LivingEntity entity() {
        return (LivingEntity)super.entity();
    }

    @Override
    public double health() {
        return this.entity().getHealth();
    }

    @Override
    public void health(double health) {
        this.entity().setHealth((float)health);
    }

    @Override
    public double maxHealth() {
        return this.entity().getMaxHealth();
    }

    @Override
    public double maxHealthOffset() {
        AttributeInstance attribute = this.entity().getAttribute(Attributes.MAX_HEALTH);
        if (attribute == null) {
            return 0.0;
        }
        AttributeModifier modifier = attribute.getModifier(ResourceLocation.withDefaultNamespace((String)MAX_HEALTH_MODIFIER_UUID.toString().toLowerCase(Locale.US)));
        return modifier == null ? 0.0 : modifier.amount();
    }

    @Override
    public void maxHealthOffset(double newOffset) {
        AttributeUtil.addModifier(this.entity(), (Holder<Attribute>)Attributes.MAX_HEALTH, MAX_HEALTH_MODIFIER_UUID, newOffset, AttributeModifier.Operation.ADD_VALUE, true);
        float computedMaxHealth = (float)(20.0 + newOffset);
        this.health(Math.min(this.health(), (double)computedMaxHealth));
    }

    @Override
    public void damage(double damage) {
        this.entity().hurt(this.entity().damageSources().generic(), (float)damage);
    }

    @Override
    public void heal(double amount) {
        this.entity().heal((float)amount);
    }
}

