/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j;

import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import live.crowdcontrol.cc4j.CCEffect;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.websocket.ConnectedPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActiveEffect {
    private static final Logger log = LoggerFactory.getLogger((String)"CrowdControl/ActiveEffect");
    @NotNull
    private final CrowdControl cc;
    @NotNull
    private final CCEffect effect;
    @NotNull
    private final PublicEffectPayload payload;
    @NotNull
    private final ConnectedPlayer player;
    @Nullable
    private ScheduledFuture<?> completer;
    @Nullable
    private Instant startedAt;
    private long timeRemaining = -1L;
    @Nullable
    private CompletableFuture<Void> responseFuture;
    @Nullable
    private Future<?> responseThread;
    @Nullable
    private ScheduledFuture<?> responseTimeout;
    private boolean completed = false;

    public ActiveEffect(@NotNull CrowdControl cc, @NotNull CCEffect effect, @NotNull PublicEffectPayload payload, @NotNull ConnectedPlayer player) {
        this.cc = cc;
        this.effect = effect;
        this.payload = payload;
        this.player = player;
    }

    @NotNull
    public PublicEffectPayload getPayload() {
        return this.payload;
    }

    @NotNull
    public ConnectedPlayer getPlayer() {
        return this.player;
    }

    public boolean isTimed() {
        return this.startedAt != null || this.timeRemaining > -1L;
    }

    public boolean isPaused() {
        return this.startedAt == null;
    }

    public boolean isCompleted() {
        return this.timeRemaining <= 0L;
    }

    @Nullable
    public Future<?> getCompleter() {
        return this.completer;
    }

    public void scheduleCompleter(long timeRemaining) {
        this.timeRemaining = timeRemaining;
        this.setCompleter(this.cc.getTimedEffectPool().schedule(this::complete, timeRemaining, TimeUnit.MILLISECONDS));
    }

    private void setCompleter(@Nullable ScheduledFuture<?> completer) {
        if (this.completer != null) {
            this.completer.cancel(false);
        }
        this.completer = completer;
        this.startedAt = completer != null ? Instant.now() : null;
    }

    public void complete() {
        if (this.completed) {
            return;
        }
        this.completed = true;
        this.timeRemaining = 0L;
        try {
            this.player.sendResponse(new CCInstantEffectResponse(this.payload.getRequestId(), ResponseStatus.TIMED_END));
        }
        catch (Exception e) {
            log.error("Failed to send response", (Throwable)e);
        }
        if (!(this.effect instanceof CCTimedEffect)) {
            return;
        }
        try {
            ((CCTimedEffect)this.effect).onEnd(this.payload, this.player);
        }
        catch (Exception e) {
            log.error("Failed to invoke {} end handler for request {}", (Object)this.payload.getEffect().getEffectId(), (Object)this.payload.getRequestId());
        }
    }

    public void pause() {
        if (this.isCompleted()) {
            return;
        }
        if (this.isPaused()) {
            return;
        }
        this.timeRemaining = this.completer != null ? Math.max(0L, this.completer.getDelay(TimeUnit.MILLISECONDS)) : 0L;
        this.setCompleter(null);
        this.player.sendResponse(new CCTimedEffectResponse(this.payload.getRequestId(), ResponseStatus.TIMED_PAUSE, this.timeRemaining));
        if (!(this.effect instanceof CCTimedEffect)) {
            return;
        }
        try {
            ((CCTimedEffect)this.effect).onPause(this.payload, this.player);
        }
        catch (Exception e) {
            log.error("Failed to invoke {} pause handler for request {}", (Object)this.payload.getEffect().getEffectId(), (Object)this.payload.getRequestId());
        }
    }

    public void resume() {
        if (this.isCompleted()) {
            return;
        }
        if (!this.isPaused()) {
            return;
        }
        this.scheduleCompleter(this.timeRemaining);
        this.player.sendResponse(new CCTimedEffectResponse(this.payload.getRequestId(), ResponseStatus.TIMED_RESUME, this.timeRemaining));
        if (!(this.effect instanceof CCTimedEffect)) {
            return;
        }
        try {
            ((CCTimedEffect)this.effect).onResume(this.payload, this.player);
        }
        catch (Exception e) {
            log.error("Failed to invoke {} resume handler for request {}", (Object)this.payload.getEffect().getEffectId(), (Object)this.payload.getRequestId());
        }
    }

    @Nullable
    public CompletableFuture<Void> getResponseFuture() {
        return this.responseFuture;
    }

    public void setResponseFuture(@Nullable CompletableFuture<Void> responseFuture) {
        this.responseFuture = responseFuture;
    }

    @Nullable
    public Future<?> getResponseThread() {
        return this.responseThread;
    }

    public void setResponseThread(@Nullable Future<?> responseThread) {
        this.responseThread = responseThread;
    }

    @Nullable
    public ScheduledFuture<?> getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(@Nullable ScheduledFuture<?> responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    @NotNull
    public CCEffect getEffect() {
        return this.effect;
    }
}

