/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.crowdcontrol.common.AbstractPlayerManager;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.GameModeCommand;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public final class PaperPlayerManager
extends AbstractPlayerManager<Player> {
    private final PaperCrowdControlPlugin plugin;

    @Override
    @NotNull
    public @NotNull List<@NotNull Player> getAllPlayersFull() {
        return new ArrayList<Player>(Bukkit.getOnlinePlayers());
    }

    @Override
    public boolean canApply(@NotNull Player player, @Nullable PublicEffectPayload request) {
        if (!player.isValid()) {
            return false;
        }
        if (player.isDead()) {
            return false;
        }
        if (this.isSpectator(player)) {
            return false;
        }
        if (!PaperUtil.hasPermission((Permissible)player, PaperUtil.toPaper(this.plugin.getUsePermission()))) {
            return false;
        }
        Permission perm = this.getEffectPermission(request).map(PaperUtil::toPaper).orElse(null);
        return perm == null || PaperUtil.hasPermission((Permissible)player, perm);
    }

    @Override
    public boolean isSpectator(@NotNull Player player) {
        return player.getGameMode() == GameMode.SPECTATOR && !GameModeCommand.isEffectActive((Plugin)this.plugin.getPaperPlugin(), (Entity)player);
    }

    @Generated
    public PaperCrowdControlPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public PaperPlayerManager(PaperCrowdControlPlugin plugin) {
        this.plugin = plugin;
    }
}

