/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.NearbyLocationCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Biome;

public class BiomeCommand
extends NearbyLocationCommand<Biome> {
    private static final Map<World.Environment, List<Biome>> BIOMES;
    private static final Map<World.Environment, List<String>> KEYED_BIOMES;
    private final String effectName = "biome";

    public BiomeCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Location search(@NotNull Location origin, @NotNull Biome searchType) {
        return origin.getWorld().locateNearestBiome(origin, searchType, 512, 32);
    }

    @Override
    @NotNull
    protected Collection<Biome> getSearchTypes(@NotNull World.Environment environment) {
        return BIOMES.get(environment);
    }

    @Override
    @NotNull
    protected Component nameOf(@NotNull Biome searchType) {
        return Component.translatable((Translatable)searchType);
    }

    @Override
    @Nullable
    protected Biome currentType(@NotNull Location origin) {
        return origin.getBlock().getBiome();
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    static {
        KEYED_BIOMES = Map.of(World.Environment.NORMAL, List.of("OCEAN", "PLAINS", "DESERT", "MOUNTAINS", "FOREST", "TAIGA", "SWAMP", "RIVER", "FROZEN_OCEAN", "FROZEN_RIVER", "SNOWY_TUNDRA", "SNOWY_MOUNTAINS", "MUSHROOM_FIELDS", "BEACH", "WOODED_HILLS", "TAIGA_HILLS", "JUNGLE", "DEEP_OCEAN", "STONE_SHORE", "STONY_SHORE", "SNOWY_BEACH", "SNOWY_PLAINS", "BIRCH_FOREST", "DARK_FOREST", "SNOWY_TAIGA", "GIANT_TREE_TAIGA", "WOODED_MOUNTAINS", "SAVANNA", "SAVANNA_PLATEAU", "BADLANDS", "WOODED_BADLANDS_PLATEAU", "BADLANDS_PLATEAU", "WARM_OCEAN", "LUKEWARM_OCEAN", "COLD_OCEAN", "DEEP_WARM_OCEAN", "DEEP_LUKEWARM_OCEAN", "DEEP_COLD_OCEAN", "DEEP_FROZEN_OCEAN", "SUNFLOWER_PLAINS", "DESERT_LAKES", "GRAVELLY_MOUNTAINS", "FLOWER_FOREST", "TAIGA_MOUNTAINS", "SWAMP_HILLS", "ICE_SPIKES", "TALL_BIRCH_FOREST", "SNOWY_TAIGA_MOUNTAINS", "GIANT_SPRUCE_TAIGA", "BAMBOO_JUNGLE", "ERODED_BADLANDS", "FROZEN_PEAKS", "GROVE", "JAGGED_PEAKS", "MEADOW", "OLD_GROWTH_BIRCH_FOREST", "OLD_GROWTH_PINE_TAIGA", "OLD_GROWTH_SPRUCE_TAIGA", "SNOWY_SLOPES", "SPARSE_JUNGLE", "STONY_PEAKS", "WINDSWEPT_FOREST", "WINDSWEPT_GRAVELLY_HILLS", "WINDSWEPT_HILLS", "WINDSWEPT_SAVANNA", "WOODED_BADLANDS", "MANGROVE_SWAMP"), World.Environment.NETHER, List.of("NETHER_WASTES", "SOUL_SAND_VALLEY", "CRIMSON_FOREST", "WARPED_FOREST", "BASALT_DELTAS"), World.Environment.THE_END, List.of("THE_END", "SMALL_END_ISLANDS", "END_MIDLANDS", "END_HIGHLANDS", "END_BARRENS"), World.Environment.CUSTOM, Registry.BIOME.stream().map(biome -> biome.key().asString()).toList());
        HashMap<World.Environment, List<Biome>> biomeMap = new HashMap<World.Environment, List<Biome>>(KEYED_BIOMES.size());
        for (Map.Entry<World.Environment, List<String>> entry : KEYED_BIOMES.entrySet()) {
            List<String> keyedBiomes = entry.getValue();
            ArrayList<Biome> biomes = new ArrayList<Biome>(keyedBiomes.size());
            for (String biomeName : keyedBiomes) {
                Biome biome2;
                NamespacedKey biomeKey = NamespacedKey.fromString((String)biomeName.toLowerCase(Locale.ROOT));
                if (biomeKey == null || (biome2 = (Biome)Registry.BIOME.get(biomeKey)) == null) continue;
                biomes.add(biome2);
            }
            biomeMap.put(entry.getKey(), biomes);
        }
        BIOMES = biomeMap;
    }
}

