/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.plugin.paper.FeatureElementCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import io.papermc.paper.world.flag.FeatureDependant;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockCommand
extends RegionalCommandSync
implements FeatureElementCommand {
    protected final Material material;
    private final String effectName;
    private final Component displayName;

    public BlockCommand(PaperCrowdControlPlugin plugin, Material block) {
        this(plugin, block, "block_" + block.key().value(), (Component)Component.translatable((String)"cc.effect.block.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)block)}));
    }

    protected BlockCommand(PaperCrowdControlPlugin plugin, Material block, String effectName, Component displayName) {
        super(plugin);
        this.material = block;
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @Override
    public boolean isFeatureEnabled(@NotNull World world) {
        return this.material.asBlockType() != null && world.isEnabled((FeatureDependant)this.material.asBlockType());
    }

    @Nullable
    protected Location getLocation(Player player) {
        Location location = player.getLocation();
        if (!location.getBlock().isReplaceable()) {
            return null;
        }
        return location;
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Location location = this.getLocation(player);
        if (location == null) {
            return false;
        }
        Block block = location.getBlock();
        Material mat = this.getMaterial();
        if (!block.isReplaceable() || block.getType() == mat) {
            return false;
        }
        block.setType(mat);
        return true;
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available locations to set blocks");
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }
}

