/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.SummonEntityCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ChargedCreeperCommand
extends SummonEntityCommand {
    private final String effectName = "entity_charged_creeper";
    private final Component displayName = this.getDefaultDisplayName();

    public ChargedCreeperCommand(PaperCrowdControlPlugin plugin) {
        super(plugin, EntityType.CREEPER);
    }

    @Override
    protected Entity spawnEntity(@Nullable Component viewer, @NotNull Player player) {
        Creeper creeper = (Creeper)super.spawnEntity(viewer, player);
        creeper.setPowered(true);
        Location pos = creeper.getLocation();
        creeper.getWorld().playSound(Sounds.LIGHTNING_STRIKE.get(new Object[0]), pos.getX(), pos.getY(), pos.getZ());
        return creeper;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }
}

