/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.crowdcontrol.plugin.paper.commands.KeepInventoryCommand;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.GameRule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;

public class ClearInventoryCommand
extends RegionalCommandSync {
    private final String effectName = "clear_inventory";

    public ClearInventoryCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All inventories are already empty or protected");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        if (KeepInventoryCommand.isKeepingInventory((Entity)player)) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        if (inv.isEmpty()) {
            return false;
        }
        inv.clear();
        return true;
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY) == Boolean.TRUE) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return KeepInventoryCommand.globalKeepInventory ? TriState.FALSE : TriState.TRUE;
        }
        TriState keepingInventory = potentialPlayers.stream().map(player -> TriState.fromBoolean(KeepInventoryCommand.isKeepingInventory(player.getUniqueId()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (keepingInventory == TriState.TRUE) {
            return TriState.FALSE;
        }
        return TriState.TRUE;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

