/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class DinnerboneCommand
extends RegionalCommandSync {
    private final NamespacedKey key;
    private final String effectName = "dinnerbone";

    public DinnerboneCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
        this.key = new NamespacedKey((Plugin)plugin.getPaperPlugin(), "original_name");
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No nearby entities");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        boolean success = false;
        for (Entity entity : player.getLocation().getNearbyLivingEntities(30.0)) {
            PersistentDataContainer data = entity.getPersistentDataContainer();
            Component currentName = entity.customName();
            if (CommandConstants.DINNERBONE_COMPONENT.equals((Object)currentName)) {
                Component savedName = (Component)data.get(this.key, PaperCrowdControlPlugin.COMPONENT_TYPE);
                entity.customName(savedName);
                if (savedName != null) {
                    entity.setCustomNameVisible(true);
                }
                data.remove(this.key);
            } else {
                if (currentName != null) {
                    data.set(this.key, PaperCrowdControlPlugin.COMPONENT_TYPE, (Object)currentName);
                }
                entity.customName(CommandConstants.DINNERBONE_COMPONENT);
                entity.setCustomNameVisible(false);
            }
            success = true;
        }
        return success;
    }

    @Generated
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

