/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class EnchantmentCommand
extends RegionalCommandSync {
    protected final Enchantment enchantment;
    private final String effectName;
    private final Component displayName;
    private final CCName extensionName;
    private final String image = "enchant_sharpness";
    private final int price = 50;
    private final byte priority = 0;
    private final List<String> categories = Collections.singletonList("Enchantments");

    public EnchantmentCommand(PaperCrowdControlPlugin plugin, Enchantment enchantment) {
        super(plugin);
        this.enchantment = enchantment;
        this.effectName = "enchant_" + (enchantment.key().namespace().equals("minecraft") ? plugin.getTextUtil().translate((Translatable)enchantment).replace(' ', '_') : CommandConstants.asMinimalSafeString(enchantment.key()));
        TranslatableComponent _displayName = Component.translatable((String)"cc.effect.enchant.name", (ComponentLike[])new ComponentLike[]{enchantment.displayName(enchantment.getMaxLevel()).color(null)});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.enchant.extension")));
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No items could be enchanted");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        int level = this.enchantment.getMaxLevel();
        PlayerInventory inv = player.getInventory();
        HashMap<EquipmentSlot, Integer> levelMap = new HashMap<EquipmentSlot, Integer>(EquipmentSlot.values().length);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item;
            try {
                item = inv.getItem(slot);
            }
            catch (Exception e) {
                this.plugin.getSLF4JLogger().debug("Failed to get equipment slot item {}", (Object)slot);
                continue;
            }
            if (item.getType().isEmpty() || !this.enchantment.canEnchantItem(item) || this.enchantment.getMaxLevel() == this.enchantment.getStartLevel() && (item.getEnchantmentLevel(this.enchantment) == this.enchantment.getMaxLevel() || item.getEnchantmentLevel(this.enchantment) == 255)) continue;
            levelMap.put(slot, item.getEnchantmentLevel(this.enchantment));
        }
        EquipmentSlot slot = levelMap.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
        if (slot == null) {
            return false;
        }
        ItemStack item = inv.getItem(slot);
        int curLevel = item.getEnchantmentLevel(this.enchantment);
        if (curLevel >= level) {
            level = curLevel + 1;
        }
        item.addUnsafeEnchantment(this.enchantment, level);
        return true;
    }

    @Generated
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }
}

