/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class FlightCommand
extends PaperCommand
implements Listener,
CCTimedEffect {
    private final String effectName = "flight";
    private final Duration defaultDuration = Duration.ofSeconds(15L);
    private final Map<UUID, List<UUID>> uuids = new HashMap<UUID, List<UUID>>();

    public FlightCommand(@NotNull PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    private void setFlying(Player player, boolean status) {
        player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $$ -> {
            player.setAllowFlight(status);
            player.setFlying(status);
        }, null);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Player player : players) {
                GameMode gameMode = player.getGameMode();
                if (gameMode == GameMode.CREATIVE || gameMode == GameMode.SPECTATOR || player.getAllowFlight() || player.isFlying()) continue;
                success = true;
                this.setFlying(player, true);
            }
            if (!success) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Target is already flying or able to fly");
            }
            this.uuids.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onPause(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<UUID> uuidList = this.uuids.get(request.getRequestId());
        if (uuidList == null) {
            return;
        }
        uuidList.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> this.setFlying((Player)player, false));
    }

    @Override
    public void onResume(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<UUID> uuidList = this.uuids.get(request.getRequestId());
        if (uuidList == null) {
            return;
        }
        uuidList.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> this.setFlying((Player)player, true));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<UUID> uuidList = this.uuids.remove(request.getRequestId());
        if (uuidList == null) {
            return;
        }
        uuidList.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).forEach(player -> this.setFlying((Player)player, false));
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        GameMode gamemode = player.getGameMode();
        if (gamemode.equals((Object)GameMode.CREATIVE)) {
            return;
        }
        if (gamemode.equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        if (!player.isFlying() && !player.getAllowFlight()) {
            return;
        }
        this.setFlying(player, false);
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Generated
    public Map<UUID, List<UUID>> getUuids() {
        return this.uuids;
    }
}

