/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class GameModeCommand
extends PaperCommand
implements CCTimedEffect {
    private final Map<UUID, List<UUID>> activeRequests = new HashMap<UUID, List<UUID>>();
    private final Duration defaultDuration;
    private final GameMode gamemode;
    private final Component displayName;
    private final String effectName;
    private final NamespacedKey gamemodeKey;
    private final String effectGroup = "gamemode";
    private final List<String> effectGroups = Collections.singletonList("gamemode");

    public GameModeCommand(PaperCrowdControlPlugin plugin, GameMode gamemode, long seconds) {
        super(plugin);
        this.gamemodeKey = GameModeCommand.getGamemodeKey((Plugin)plugin.getPaperPlugin());
        this.defaultDuration = Duration.ofSeconds(seconds);
        this.gamemode = gamemode;
        this.displayName = Component.translatable((Translatable)gamemode);
        this.effectName = gamemode.name().toLowerCase() + "_mode";
    }

    private static NamespacedKey getGamemodeKey(Plugin plugin) {
        return new NamespacedKey(plugin, "is_gamemode_active");
    }

    private static boolean isEffectActive(NamespacedKey key, Entity player) {
        return (Boolean)player.getPersistentDataContainer().getOrDefault(key, PaperCrowdControlPlugin.BOOLEAN_TYPE, (Object)false);
    }

    public static boolean isEffectActive(@Nullable Plugin plugin, Entity player) {
        if (plugin == null) {
            return false;
        }
        return GameModeCommand.isEffectActive(GameModeCommand.getGamemodeKey(plugin), player);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            this.activeRequests.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            this.setGameMode(players, this.gamemode, true);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<Player> players = PaperUtil.toPlayers(this.activeRequests.remove(request.getRequestId()));
        this.setGameMode(players, GameMode.SURVIVAL, false);
    }

    private void setGameMode(@NotNull @NotNull List<@NotNull Player> players, @NotNull GameMode gamemode, boolean enabling) {
        players.forEach(player -> player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
            player.setGameMode(gamemode);
            player.getPersistentDataContainer().set(this.gamemodeKey, PaperCrowdControlPlugin.BOOLEAN_TYPE, (Object)enabling);
        }, null));
    }

    @Generated
    public Map<UUID, List<UUID>> getActiveRequests() {
        return this.activeRequests;
    }

    @Generated
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Generated
    public GameMode getGamemode() {
        return this.gamemode;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Generated
    public NamespacedKey getGamemodeKey() {
        return this.gamemodeKey;
    }

    @Generated
    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public static final class Manager
    implements Listener {
        private final NamespacedKey key;

        public Manager(Plugin plugin) {
            this.key = GameModeCommand.getGamemodeKey(plugin);
        }

        @EventHandler
        public void onJoin(PlayerJoinEvent event) {
            Player player = event.getPlayer();
            if (!GameModeCommand.isEffectActive(this.key, (Entity)player)) {
                return;
            }
            player.getPersistentDataContainer().set(this.key, PaperCrowdControlPlugin.BOOLEAN_TYPE, (Object)false);
            player.setGameMode(GameMode.SURVIVAL);
        }
    }
}

