/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CrowdControl;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.sound.Sound;
import org.bukkit.GameRule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class KeepInventoryCommand
extends PaperCommand {
    private static final Set<UUID> keepingInventory = Collections.synchronizedSet(new HashSet(1));
    private final boolean enable;
    private final String effectName;
    public static boolean globalKeepInventory = false;

    public KeepInventoryCommand(PaperCrowdControlPlugin plugin, boolean enable) {
        super(plugin);
        this.enable = enable;
        this.effectName = "keep_inventory_" + (enable ? "on" : "off");
    }

    public static boolean isKeepingInventory(UUID player) {
        return globalKeepInventory || keepingInventory.contains(player);
    }

    public static boolean isKeepingInventory(Entity player) {
        return KeepInventoryCommand.isKeepingInventory(player.getUniqueId());
    }

    private void alert(Collection<? extends Audience> players) {
        ForwardingAudience audience = Audience.audience(players);
        audience.sendActionBar(this.enable ? CommandConstants.KEEP_INVENTORY_MESSAGE : CommandConstants.LOSE_INVENTORY_MESSAGE);
        audience.playSound((this.enable ? Sounds.KEEP_INVENTORY_ALERT : Sounds.LOSE_INVENTORY_ALERT).get(new Object[0]), Sound.Emitter.self());
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            if (this.plugin.isGlobal()) {
                CrowdControl cc = this.plugin.getCrowdControl();
                if (cc == null) {
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Mod is not loaded");
                }
                if (globalKeepInventory == this.enable) {
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Keep Inventory is already " + (this.enable ? "enabled" : "disabled"));
                }
                globalKeepInventory = this.enable;
                this.alert(players);
                this.plugin.updateConditionalEffectVisibility();
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            ArrayList<UUID> uuids = new ArrayList<UUID>(players.size());
            for (Player player : players) {
                uuids.add(player.getUniqueId());
            }
            if (this.enable) {
                if (keepingInventory.addAll(uuids)) {
                    this.alert(players);
                    players.forEach(this.plugin::updateConditionalEffectVisibility);
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
                }
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory enabled");
            }
            if (keepingInventory.removeAll(uuids)) {
                this.alert(players);
                players.forEach(this.plugin::updateConditionalEffectVisibility);
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory disabled");
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.getWorld().getGameRuleValue(GameRule.KEEP_INVENTORY) == Boolean.TRUE) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return globalKeepInventory == this.enable ? TriState.FALSE : TriState.TRUE;
        }
        TriState state = potentialPlayers.stream().map(player -> TriState.fromBoolean(this.enable != KeepInventoryCommand.isKeepingInventory(player.getUniqueId()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (state == TriState.FALSE) {
            return state;
        }
        return TriState.TRUE;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    public static final class Manager
    implements Listener {
        @EventHandler
        public void onDeath(PlayerDeathEvent event) {
            if (!KeepInventoryCommand.isKeepingInventory((Entity)event.getEntity())) {
                return;
            }
            event.setKeepInventory(true);
            event.getDrops().clear();
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
    }
}

