/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.crowdcontrol.plugin.paper.commands.ItemCommand;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ListIterator;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class TakeItemCommand
extends RegionalCommandSync
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final Material item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public TakeItemCommand(PaperCrowdControlPlugin plugin, Material item) {
        super(plugin);
        this.item = item;
        this.effectName = "take_" + item.key().value();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.take_item.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)new ItemStack(item))});
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Item could not be found in target inventories");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ItemStack itemStack;
        int amount = request.getQuantity();
        PlayerInventory inventory = player.getInventory();
        int toTake = 0;
        ListIterator listIterator = inventory.iterator();
        while (listIterator.hasNext() && ((itemStack = (ItemStack)listIterator.next()) == null || itemStack.getType() != this.item || (toTake += itemStack.getAmount()) < amount)) {
        }
        if (toTake < amount) {
            return false;
        }
        toTake = amount;
        for (int i = 0; i < inventory.getSize(); ++i) {
            itemStack = inventory.getItem(i);
            if (itemStack == null || itemStack.getType() != this.item) continue;
            int take = Math.min(itemStack.getAmount(), toTake);
            itemStack.setAmount(itemStack.getAmount() - take);
            if ((toTake -= take) == 0) break;
        }
        return true;
    }

    @Override
    @NotNull
    @Generated
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @Generated
    public Material getItem() {
        return this.item;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

