/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.commands.GiveItemCommand;
import dev.qixils.crowdcontrol.plugin.paper.commands.LootboxCommand;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.Condition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.SuccessCondition;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DoOrDieCommand
extends PaperCommand
implements CCTimedEffect {
    private final String effectName = "do_or_die";

    public DoOrDieCommand(@NotNull PaperCrowdControlPlugin plugin) {
        super(plugin);
        for (SuccessCondition condition : Condition.items()) {
            if (!(condition instanceof Listener)) continue;
            Listener listener = (Listener)condition;
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)plugin.getPaperPlugin());
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            ArrayList<SuccessCondition> conditions = new ArrayList<SuccessCondition>(Condition.items());
            Collections.shuffle(conditions, random);
            CompletableFuture<Object> cond = new CompletableFuture<Object>();
            for (SuccessCondition condition : conditions) {
                AtomicInteger applicable = new AtomicInteger();
                for (Player player2 : players) {
                    player2.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
                        if (condition.canApply(player2) && applicable.addAndGet(1) == players.size()) {
                            cond.complete(condition);
                        }
                    }, null);
                }
            }
            SuccessCondition condition = cond.completeOnTimeout(null, 1000L, TimeUnit.MILLISECONDS).join();
            if (condition == null) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a challenge to apply");
            }
            Component subtitle = condition.getComponent();
            Set notCompleted = players.stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toSet());
            players.forEach(player -> player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> condition.track((Player)player), null));
            AtomicInteger pastValue = new AtomicInteger();
            AtomicInteger ticks = new AtomicInteger(1);
            int tickRate = 2;
            Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin.getPaperPlugin(), task -> {
                int ticksElapsed = ticks.addAndGet(tickRate);
                int secondsLeft = (int)CommandConstants.DO_OR_DIE_DURATION.getSeconds() - (int)Math.ceil((float)ticksElapsed / 20.0f);
                boolean isNewValue = secondsLeft != pastValue.getAndSet(secondsLeft);
                boolean isTimeUp = secondsLeft <= 0;
                for (UUID uuid : notCompleted) {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null) continue;
                    player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
                        if (condition.hasSucceeded(player)) {
                            ItemStack reward = LootboxCommand.createRandomItem(condition.getRewardLuck(), null);
                            player.showTitle(CommandConstants.doOrDieSuccess((Translatable)reward.getType()));
                            notCompleted.remove(uuid);
                            player.playSound(Sounds.DO_OR_DIE_SUCCESS_CHIME.get(new Object[0]), (Sound.Emitter)player);
                            GiveItemCommand.giveItemTo((Entity)player, reward);
                        } else if (isTimeUp) {
                            condition.reset(player);
                            player.showTitle(CommandConstants.DO_OR_DIE_FAILURE);
                            player.setHealth(0.0);
                        } else {
                            Component main = Component.text((int)secondsLeft).color(CommandConstants.doOrDieColor(secondsLeft));
                            player.showTitle(Title.title((Component)main, (Component)subtitle, (Title.Times)CommandConstants.DO_OR_DIE_TIMES));
                            if (isNewValue) {
                                player.playSound(Sounds.DO_OR_DIE_TICK.get(new Object[0]), (Sound.Emitter)player);
                            }
                        }
                    }, null);
                }
                if (isTimeUp) {
                    task.cancel();
                }
            }, 1L, (long)tickRate);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

