/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.injection;

import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.cloud.injection.InjectionRequest;
import dev.qixils.relocated.cloud.injection.InjectionService;
import dev.qixils.relocated.cloud.util.annotation.AnnotationAccessor;
import java.lang.annotation.Annotation;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private static <T> @NonNull Key<T> createKey(@NonNull Class<T> clazz, @NonNull AnnotationAccessor annotationAccessor) {
        Annotation bindingAnnotation = annotationAccessor.annotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(BindingAnnotation.class)).findFirst().orElse(null);
        if (bindingAnnotation == null) {
            return Key.get(clazz);
        }
        return Key.get(clazz, (Annotation)bindingAnnotation);
    }

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> @NonNull GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull InjectionRequest<C> request) {
        try {
            return this.injector.getInstance(GuiceInjectionService.createKey(request.injectedClass(), request.annotationAccessor()));
        }
        catch (ConfigurationException ignored) {
            return null;
        }
    }
}

