/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.parser.standard;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.NumberParseException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.parser.standard.IntegerParser;
import dev.qixils.relocated.cloud.parser.standard.NumberParser;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import dev.qixils.relocated.cloud.type.range.LongRange;
import dev.qixils.relocated.cloud.type.range.Range;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class LongParser<C>
extends NumberParser<C, Long, LongRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final long DEFAULT_MINIMUM = Long.MIN_VALUE;
    @API(status=API.Status.STABLE)
    public static final long DEFAULT_MAXIMUM = Long.MAX_VALUE;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser() {
        return LongParser.longParser(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser(long minValue) {
        return ParserDescriptor.of(new LongParser<C>(minValue, Long.MAX_VALUE), Long.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser(long minValue, long maxValue) {
        return ParserDescriptor.of(new LongParser<C>(minValue, maxValue), Long.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Long> longComponent() {
        return CommandComponent.builder().parser(LongParser.longParser());
    }

    public LongParser(long min, long max) {
        super(Range.longRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Long> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidLong((LongRange)this.range())) {
            return ArgumentParseResult.failure(new LongParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readLong());
    }

    @Override
    public boolean hasMax() {
        return ((LongRange)this.range()).maxLong() != Long.MAX_VALUE;
    }

    @Override
    public boolean hasMin() {
        return ((LongRange)this.range()).minLong() != Long.MIN_VALUE;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return IntegerParser.getSuggestions(this.range(), input);
    }

    @API(status=API.Status.STABLE)
    public static final class LongParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public LongParseException(@NonNull String input, @NonNull LongParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "long";
        }
    }
}

