/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.maxhealth;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;

public class MaxHealthCommand<P>
implements Command<P> {
    private final String effectName;
    private final Component displayName;
    private final int amount;
    private final Plugin<P, ?> plugin;

    public MaxHealthCommand(Plugin<P, ?> plugin, int amount) {
        Object displayText;
        Object amountText;
        this.plugin = plugin;
        if (amount == 0) {
            amountText = "0";
            displayText = "0";
        } else if (amount < 0) {
            amountText = "sub" + amount * -1;
            displayText = String.valueOf(amount);
        } else {
            amountText = "plus" + amount;
            displayText = "+" + amount;
        }
        this.effectName = "max_health_" + (String)amountText;
        this.displayName = Component.translatable((String)"cc.effect.max_health.name", (ComponentLike[])new ComponentLike[]{Component.text((String)displayText)});
        this.amount = amount;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                double newVal;
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                double current = player.maxHealthOffset();
                if (current == (newVal = Math.max(-10.0, current + (double)this.amount))) continue;
                success = true;
                player.maxHealthOffset(newVal);
                if (this.amount <= 0) continue;
                player.health(player.health() + (double)this.amount);
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players are at minimum health (5 hearts)");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }
}

