/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.exceptions;

import dev.qixils.relocated.annotations.ApiStatus;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.function.Supplier;

@ApiStatus.AvailableSince(value="3.3.0")
public class ExceptionUtil {
    private ExceptionUtil() {
        throw new IllegalStateException("Utility class");
    }

    @ApiStatus.AvailableSince(value="3.3.0")
    public static boolean isCause(@NotNull Class<? extends Throwable> potentialCause, @Nullable Throwable exception) {
        ExceptionUtil.validateNotNull(potentialCause, "potentialCause");
        if (exception == null) {
            return false;
        }
        if (potentialCause.isInstance(exception)) {
            return true;
        }
        return ExceptionUtil.isCause(potentialCause, exception.getCause());
    }

    @Contract(value="null -> fail; !null -> !null")
    @NotNull
    @ApiStatus.AvailableSince(value="3.3.0")
    public static <T> T validateNotNull(@Nullable T object) throws IllegalArgumentException {
        return ExceptionUtil.validateNotNull(object, null);
    }

    @Contract(value="null, _ -> fail; !null, _ -> !null")
    @NotNull
    @ApiStatus.AvailableSince(value="3.3.0")
    public static <T> T validateNotNull(@Nullable T object, @Nullable String variableName) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(ExceptionUtil.validateNotNullElse(variableName, "Object") + " cannot be null");
        }
        return object;
    }

    @Contract(value="!null, _ -> param1; null, _ -> param2")
    @NotNull
    @ApiStatus.AvailableSince(value="3.3.1")
    public static <T> T validateNotNullElse(@Nullable T object1, @NotNull T object2) {
        if (object1 != null) {
            return object1;
        }
        return ExceptionUtil.validateNotNull(object2);
    }

    @Contract(value="!null, _ -> param1")
    @NotNull
    @ApiStatus.AvailableSince(value="3.3.1")
    public static <T> T validateNotNullElseGet(@Nullable T object, @NotNull @NotNull Supplier<@NotNull T> provider) {
        if (object != null) {
            return object;
        }
        return ExceptionUtil.validateNotNull(ExceptionUtil.validateNotNull(provider).get());
    }
}

