/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper;

import dev.qixils.crowdcontrol.common.CustomEffectsConfig;
import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.HideNames;
import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.SoftLockConfig;
import dev.qixils.crowdcontrol.common.VersionMetadata;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.packets.ExtraFeaturePacketC2S;
import dev.qixils.crowdcontrol.common.packets.MovementStatusPacketS2C;
import dev.qixils.crowdcontrol.common.packets.SetLanguagePacketS2C;
import dev.qixils.crowdcontrol.common.packets.ShaderPacketS2C;
import dev.qixils.crowdcontrol.common.packets.VersionRequestPacketS2C;
import dev.qixils.crowdcontrol.common.packets.VersionResponsePacketC2S;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.TextUtilImpl;
import dev.qixils.crowdcontrol.plugin.paper.BooleanDataType;
import dev.qixils.crowdcontrol.plugin.paper.CommandRegister;
import dev.qixils.crowdcontrol.plugin.paper.CommandSenderMapper;
import dev.qixils.crowdcontrol.plugin.paper.CommandSourceStackMapper;
import dev.qixils.crowdcontrol.plugin.paper.ComponentDataType;
import dev.qixils.crowdcontrol.plugin.paper.EnumDataType;
import dev.qixils.crowdcontrol.plugin.paper.FeatureElementCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperLoader;
import dev.qixils.crowdcontrol.plugin.paper.PaperPlayerManager;
import dev.qixils.crowdcontrol.plugin.paper.PlayerMapper;
import dev.qixils.crowdcontrol.plugin.paper.PluginChannel;
import dev.qixils.crowdcontrol.plugin.paper.SoftLockResolver;
import dev.qixils.crowdcontrol.plugin.paper.mc.PaperPlayer;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.cloud.execution.ExecutionCoordinator;
import dev.qixils.relocated.cloud.paper.PaperCommandManager;
import dev.qixils.relocated.paperlib.PaperLib;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataType;

public final class PaperCrowdControlPlugin
extends Plugin<Player, CommandSourceStack>
implements Listener {
    @NotNull
    public static final ComponentLogger LOGGER = ComponentLogger.logger((String)"CrowdControl/Plugin");
    @NotNull
    public static final SemVer MINECRAFT_MIN_VERSION = new SemVer(1, 20, 6);
    @NotNull
    public static final SemVer MINECRAFT_VERSION = new SemVer(Bukkit.getMinecraftVersion());
    private static final Map<String, Boolean> VALID_SOUNDS = new HashMap<String, Boolean>();
    public static final PersistentDataType<Byte, Boolean> BOOLEAN_TYPE = new BooleanDataType();
    public static final PersistentDataType<String, Component> COMPONENT_TYPE = new ComponentDataType();
    public static final PersistentDataType<String, MovementStatusValue> MOVEMENT_STATUS_VALUE_TYPE = new EnumDataType<MovementStatusValue>(MovementStatusValue.class, o -> o.orElse(MovementStatusValue.ALLOWED));
    private final Executor syncExecutor;
    private final Executor asyncExecutor;
    private final Path dataFolder;
    private final PlayerEntityMapper<Player> playerMapper = new PlayerMapper(this);
    private final EntityMapper<CommandSourceStack> commandSenderMapper = new CommandSourceStackMapper(new CommandSenderMapper<CommandSender>(this));
    private final SoftLockResolver softLockResolver = new SoftLockResolver(this);
    private final PaperPlayerManager playerManager = new PaperPlayerManager(this);
    private final TextUtilImpl textUtil = new TextUtilImpl(Bukkit.getUnsafe().componentFlattener());
    private final PaperLoader paperPlugin;
    private PaperCommandManager<CommandSourceStack> commandManager;
    private final CommandRegister commandRegister = new CommandRegister(this);
    @NotNull
    private final PluginChannel pluginChannel = new PluginChannel(this);

    public PaperCrowdControlPlugin(@NotNull PaperLoader paperPlugin) {
        super(Player.class, CommandSourceStack.class);
        this.dataFolder = paperPlugin.getDataFolder().toPath().resolve("Data");
        this.paperPlugin = paperPlugin;
        this.syncExecutor = runnable -> Bukkit.getGlobalRegionScheduler().execute((org.bukkit.plugin.Plugin)paperPlugin, runnable);
        this.asyncExecutor = runnable -> Bukkit.getAsyncScheduler().runNow((org.bukkit.plugin.Plugin)paperPlugin, $ -> runnable.run());
    }

    public void onLoad() {
        this.paperPlugin.saveDefaultConfig();
        CommandConstants.SOUND_VALIDATOR = _key -> {
            NamespacedKey key = PaperUtil.toPaper(_key);
            String asString = key.asMinimalString();
            Boolean value = VALID_SOUNDS.get(asString);
            if (value != null) {
                return value;
            }
            value = Registry.SOUNDS.get(key) != null;
            VALID_SOUNDS.put(asString, value);
            return value;
        };
        this.pluginChannel.registerOutgoingPluginChannel(VersionRequestPacketS2C.METADATA);
        this.pluginChannel.registerOutgoingPluginChannel(ShaderPacketS2C.METADATA);
        this.pluginChannel.registerOutgoingPluginChannel(MovementStatusPacketS2C.METADATA);
        this.pluginChannel.registerOutgoingPluginChannel(SetLanguagePacketS2C.METADATA);
        this.pluginChannel.registerIncomingPluginChannel(VersionResponsePacketC2S.METADATA, (player, message) -> {
            UUID uuid = player.getUniqueId();
            SemVer version = message.version();
            this.getSLF4JLogger().info("Received version {} from client {}", (Object)version, (Object)uuid);
            this.clientVersions.put(uuid, version);
            this.updateConditionalEffectVisibility(player);
        });
        this.pluginChannel.registerIncomingPluginChannel(ExtraFeaturePacketC2S.METADATA, (player, message) -> {
            UUID uuid = player.getUniqueId();
            Set<ExtraFeature> features = message.features();
            this.getSLF4JLogger().info("Received features {} from client {}", features, (Object)uuid);
            this.extraFeatures.put(uuid, features);
            this.updateConditionalEffectVisibility(player);
        });
    }

    @Override
    public void loadConfig() {
        ConfigurationSection limitSection;
        this.paperPlugin.reloadConfig();
        FileConfiguration config = this.paperPlugin.getConfig();
        ConfigurationSection softLockSection = config.getConfigurationSection("soft-lock-observer");
        if (softLockSection == null) {
            LOGGER.debug("No soft-lock config found, using defaults");
            this.softLockConfig = new SoftLockConfig();
        } else {
            LOGGER.debug("Loading soft-lock config");
            this.softLockConfig = new SoftLockConfig(softLockSection.getInt("period", 120), softLockSection.getInt("deaths", 6), softLockSection.getInt("search-horizontal", 20), softLockSection.getInt("search-vertical", 8));
        }
        ConfigurationSection customEffectsSection = config.getConfigurationSection("custom-effects");
        if (customEffectsSection == null) {
            LOGGER.debug("No custom effects config found, using defaults");
            this.customEffectsConfig = new CustomEffectsConfig();
        } else {
            LOGGER.debug("Loading custom effects config");
            this.customEffectsConfig = new CustomEffectsConfig(customEffectsSection.getBoolean("enabled", true));
        }
        this.hosts = Collections.unmodifiableCollection(config.getStringList("hosts"));
        if (!this.hosts.isEmpty()) {
            HashSet<String> loweredHosts = new HashSet<String>(this.hosts.size());
            for (String host : this.hosts) {
                loweredHosts.add(host.toLowerCase(Locale.ENGLISH));
            }
            this.hosts = Collections.unmodifiableSet(loweredHosts);
        }
        if ((limitSection = config.getConfigurationSection("limits")) == null) {
            LOGGER.debug("No limit config found, using defaults");
            this.limitConfig = new LimitConfig();
        } else {
            LOGGER.debug("Loading limit config");
            boolean hostsBypass = limitSection.getBoolean("hosts-bypass", true);
            Map<String, Integer> itemLimits = PaperCrowdControlPlugin.parseLimitConfigSection(limitSection.getConfigurationSection("items"));
            Map<String, Integer> entityLimits = PaperCrowdControlPlugin.parseLimitConfigSection(limitSection.getConfigurationSection("entities"));
            this.limitConfig = new LimitConfig(hostsBypass, itemLimits, entityLimits);
        }
        this.global = config.getBoolean("global", this.global);
        this.announce = config.getBoolean("announce", this.announce);
        this.adminRequired = config.getBoolean("admin-required", this.adminRequired);
        this.hideNames = HideNames.fromConfigCode(config.getString("hide-names", this.hideNames.getConfigCode()));
    }

    @Contract(value="null -> null; !null -> !null")
    private static Map<String, Integer> parseLimitConfigSection(@Nullable ConfigurationSection section) {
        if (section == null) {
            return null;
        }
        Set keys = section.getKeys(false);
        HashMap<String, Integer> map = new HashMap<String, Integer>(keys.size());
        for (String key : keys) {
            map.put(key, section.getInt(key));
        }
        return map;
    }

    public void onEnable() {
        if (!PaperLib.isPaper()) {
            throw new IllegalStateException("The Paper server software is required. Please upgrade from Spigot to Paper, it should be a simple and painless upgrade in 99.99% of cases.");
        }
        if (MINECRAFT_VERSION.isLessThan(MINECRAFT_MIN_VERSION)) {
            throw new IllegalStateException("Versions prior to " + String.valueOf(MINECRAFT_MIN_VERSION) + " are no longer supported.");
        }
        this.initCrowdControl();
        Bukkit.getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this.paperPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.softLockResolver, (org.bukkit.plugin.Plugin)this.paperPlugin);
        try {
            this.commandManager = PaperCommandManager.builder().executionCoordinator(ExecutionCoordinator.asyncCoordinator()).buildOnEnable((org.bukkit.plugin.Plugin)this.paperPlugin);
            this.registerChatCommands();
        }
        catch (Exception exception) {
            throw new IllegalStateException("The command manager was unable to load. Please ensure you are using the latest version of Paper.", exception);
        }
    }

    @NotNull
    public ComponentLogger getSLF4JLogger() {
        return LOGGER;
    }

    public void onDisable() {
        this.shutdown();
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return Bukkit.getConsoleSender();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.onPlayerJoin(player);
        if (!this.clientVersions.containsKey(player.getUniqueId())) {
            player.getScheduler().execute((org.bukkit.plugin.Plugin)this.paperPlugin, () -> this.pluginChannel.sendMessage(player, VersionRequestPacketS2C.INSTANCE), null, 10L);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.clientVersions.remove(uuid);
        this.extraFeatures.remove(uuid);
        this.onPlayerLeave(event.getPlayer());
    }

    @Override
    @NotNull
    public MCCCPlayer getPlayer(@NotNull Player player) {
        return new PaperPlayer(this, player);
    }

    @Override
    @Nullable
    public Player asPlayer(@NotNull CommandSourceStack sender) {
        return (Player)this.objAsPlayer(sender.getSender());
    }

    @Override
    @NotNull
    public VersionMetadata getVersionMetadata() {
        OptionalInt build = ServerBuildInfo.buildInfo().buildNumber();
        return new VersionMetadata(ServerBuildInfo.buildInfo().minecraftVersionId(), "Paper", ServerBuildInfo.buildInfo().brandName(), build.isPresent() ? Integer.toString(build.getAsInt()) : null);
    }

    public static boolean isFeatureEnabled(FeatureElementCommand feature) {
        return Bukkit.getWorlds().stream().allMatch(feature::isFeatureEnabled);
    }

    public static boolean isFeatureEnabled(Material material) {
        return Bukkit.getWorlds().stream().allMatch(arg_0 -> ((Material)material).isEnabledByFeature(arg_0));
    }

    public static boolean isFeatureEnabled(EntityType entityType) {
        return Bukkit.getWorlds().stream().allMatch(arg_0 -> ((EntityType)entityType).isEnabledByFeature(arg_0));
    }

    @Override
    public Executor getSyncExecutor() {
        return this.syncExecutor;
    }

    @Override
    public Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Override
    public Path getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public PlayerEntityMapper<Player> playerMapper() {
        return this.playerMapper;
    }

    @Override
    public EntityMapper<CommandSourceStack> commandSenderMapper() {
        return this.commandSenderMapper;
    }

    public PaperPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public TextUtilImpl getTextUtil() {
        return this.textUtil;
    }

    public PaperLoader getPaperPlugin() {
        return this.paperPlugin;
    }

    @Override
    public PaperCommandManager<CommandSourceStack> getCommandManager() {
        return this.commandManager;
    }

    public CommandRegister commandRegister() {
        return this.commandRegister;
    }

    @NotNull
    public PluginChannel getPluginChannel() {
        return this.pluginChannel;
    }
}

