/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommand;
import dev.qixils.relocated.annotations.NotNull;
import java.util.concurrent.CompletableFuture;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BucketClutchCommand
extends RegionalCommand {
    private final String effectName = "bucket_clutch";

    public BucketClutchCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No players are on the surface");
    }

    @Override
    protected CompletableFuture<Boolean> executeRegionallyAsync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Material material = player.getWorld().isUltraWarm() ? Material.COBWEB : Material.WATER_BUCKET;
        ItemStack giveItem = new ItemStack(material);
        giveItem.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        Location curr = player.getLocation();
        int offset = 99;
        for (int y = 1; y <= 100; ++y) {
            Block block = curr.clone().add(0.0, (double)y, 0.0).getBlock();
            if (block.isPassable()) continue;
            offset = y - 2;
            break;
        }
        if (offset < 30) {
            return CompletableFuture.completedFuture(false);
        }
        Location dest = curr.clone().add(0.0, (double)offset, 0.0);
        return player.teleportAsync(dest).thenApply(success -> {
            if (!success.booleanValue()) {
                return false;
            }
            PlayerInventory inv = player.getInventory();
            ItemStack hand = inv.getItemInMainHand();
            Material handType = hand.getType();
            if (!handType.isEmpty() && handType != material && hand.getAmount() > 0) {
                ItemStack offhand = inv.getItemInOffHand();
                if (offhand.getAmount() == 0 || offhand.getType().isEmpty()) {
                    inv.setItemInOffHand(hand);
                } else {
                    boolean slotFound = false;
                    for (int i = 0; i < 36; ++i) {
                        ItemStack item = inv.getItem(i);
                        if (item != null && item.getAmount() != 0 && !item.getType().isEmpty()) continue;
                        slotFound = true;
                        inv.setItem(i, hand);
                        break;
                    }
                    if (!slotFound) {
                        player.dropItem(true);
                    }
                }
            }
            inv.setItemInMainHand(giveItem);
            return true;
        });
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

