/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.Global;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Global
public class DifficultyCommand
extends PaperCommand {
    private static final Logger log = LoggerFactory.getLogger(DifficultyCommand.class);
    private final Difficulty difficulty;
    private final String effectName;
    private final Component displayName;

    private static String effectNameOf(Difficulty difficulty) {
        return "difficulty_" + difficulty.name();
    }

    public DifficultyCommand(PaperCrowdControlPlugin plugin, Difficulty difficulty) {
        super(plugin);
        this.difficulty = difficulty;
        this.effectName = DifficultyCommand.effectNameOf(difficulty);
        this.displayName = Component.translatable((String)"cc.effect.difficulty.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)difficulty)});
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            playerSupplier.get();
            if (this.difficulty.equals((Object)this.getCurrentDifficulty())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Server difficulty is already on " + this.plugin.getTextUtil().asPlain((ComponentLike)this.displayName));
            }
            this.sync(() -> Bukkit.getServer().getWorlds().forEach(world -> world.setDifficulty(this.difficulty)));
            this.plugin.optionalCrowdControl().ifPresent(cc -> cc.getPlayers().forEach(this.plugin::updateConditionalEffectVisibility));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Nullable
    private Difficulty getCurrentDifficulty() {
        Difficulty difficulty = null;
        for (World world : Bukkit.getServer().getWorlds()) {
            if (difficulty == null) {
                difficulty = world.getDifficulty();
                continue;
            }
            if (difficulty.equals((Object)world.getDifficulty())) continue;
            return null;
        }
        return difficulty;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        return this.difficulty.equals((Object)this.getCurrentDifficulty()) ? TriState.FALSE : TriState.TRUE;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }
}

