/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.AttributeUtil;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GravityCommand
extends PaperCommand
implements CCTimedEffect {
    private final String effectName;
    private final String effectGroup = "gravity";
    private final List<String> effectGroups = Collections.singletonList("gravity");
    private final Map<UUID, List<UUID>> playerMap = new HashMap<UUID, List<UUID>>();
    private final double gravityLevel;
    private final double fallLevel;
    private final double fallDmgLevel;

    private GravityCommand(PaperCrowdControlPlugin plugin, String effectName, double gravityLevel, double fallLevel, double fallDmgLevel) {
        super(plugin);
        this.effectName = effectName;
        this.gravityLevel = gravityLevel;
        this.fallLevel = fallLevel;
        this.fallDmgLevel = fallDmgLevel;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, "freeze", "gravity")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            this.playerMap.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            players.forEach(player -> player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
                AttributeUtil.addModifier((Attributable)player, Attribute.GRAVITY, CommandConstants.GRAVITY_MODIFIER_UUID, "gravity-cc", this.gravityLevel, AttributeModifier.Operation.ADD_SCALAR, false);
                AttributeUtil.addModifier((Attributable)player, Attribute.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID, "fall-cc", this.fallLevel, AttributeModifier.Operation.ADD_SCALAR, false);
                AttributeUtil.addModifier((Attributable)player, Attribute.FALL_DAMAGE_MULTIPLIER, CommandConstants.FALL_DMG_MODIFIER_UUID, "fall-dmg-cc", this.fallDmgLevel, AttributeModifier.Operation.ADD_NUMBER, false);
            }, null));
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<Player> players = PaperUtil.toPlayers(this.playerMap.remove(request.getRequestId()));
        players.forEach(player -> player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> {
            AttributeUtil.removeModifier((Attributable)player, Attribute.GRAVITY, CommandConstants.GRAVITY_MODIFIER_UUID);
            AttributeUtil.removeModifier((Attributable)player, Attribute.SAFE_FALL_DISTANCE, CommandConstants.FALL_MODIFIER_UUID);
        }, null));
    }

    @NotNull
    public static GravityCommand zero(PaperCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "zero_gravity", -1.0, 0.0, 0.0);
    }

    @NotNull
    public static GravityCommand low(PaperCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "low_gravity", -0.5, 1.0, -0.5);
    }

    @NotNull
    public static GravityCommand high(PaperCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "high_gravity", 1.0, -0.5, 1.0);
    }

    @NotNull
    public static GravityCommand maximum(PaperCrowdControlPlugin plugin) {
        return new GravityCommand(plugin, "maximum_gravity", 3.0, -1.0, 3.0);
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public Map<UUID, List<UUID>> getPlayerMap() {
        return this.playerMap;
    }

    public double getGravityLevel() {
        return this.gravityLevel;
    }

    public double getFallLevel() {
        return this.fallLevel;
    }

    public double getFallDmgLevel() {
        return this.fallDmgLevel;
    }
}

