/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.packets.MovementStatusPacketS2C;
import dev.qixils.crowdcontrol.common.util.ComparableUtil;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.utils.PaperUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataContainer;

public class MovementStatusCommand
extends PaperCommand
implements CCTimedEffect {
    private final Map<UUID, List<UUID>> idMap = new HashMap<UUID, List<UUID>>();
    private final String effectName;
    private final String effectGroup;
    private final Duration defaultDuration;
    private final MovementStatusType type;
    private final MovementStatusValue value;
    private final SemVer minimumModVersion;

    public MovementStatusCommand(PaperCrowdControlPlugin plugin, String effectName, String effectGroup, Duration defaultDuration, MovementStatusType type, MovementStatusValue value, boolean clientOnly) {
        super(plugin);
        this.effectName = effectName;
        this.effectGroup = effectGroup;
        this.defaultDuration = defaultDuration;
        this.type = type;
        this.value = value;
        this.minimumModVersion = clientOnly ? ComparableUtil.max(type.addedIn(), value.addedIn()) : SemVer.ZERO;
    }

    public MovementStatusCommand(PaperCrowdControlPlugin plugin, String effectName, Duration defaultDuration, MovementStatusType type, MovementStatusValue value, boolean clientOnly) {
        this(plugin, effectName, effectName, defaultDuration, type, value, clientOnly);
    }

    private static NamespacedKey key(@NotNull MovementStatusType type) {
        return new NamespacedKey("crowdcontrol", "movement-status-" + type.name().toLowerCase().replace('_', '-'));
    }

    @NotNull
    public static MovementStatusValue getValue(@NotNull Player player, @NotNull MovementStatusType type) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        NamespacedKey key = MovementStatusCommand.key(type);
        return (MovementStatusValue)pdc.getOrDefault(key, PaperCrowdControlPlugin.MOVEMENT_STATUS_VALUE_TYPE, (Object)MovementStatusValue.ALLOWED);
    }

    public static void setValue(@NotNull PaperCrowdControlPlugin plugin, @NotNull Player player, @NotNull MovementStatusType type, @NotNull MovementStatusValue value) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        NamespacedKey key = MovementStatusCommand.key(type);
        if (value == MovementStatusValue.ALLOWED) {
            pdc.remove(key);
        } else {
            pdc.set(key, PaperCrowdControlPlugin.MOVEMENT_STATUS_VALUE_TYPE, (Object)value);
        }
        plugin.getPluginChannel().sendMessage(player, new MovementStatusPacketS2C(type, value));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            if (players.isEmpty()) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No targetable players online");
            }
            this.idMap.put(request.getRequestId(), players.stream().map(OfflinePlayer::getUniqueId).toList());
            for (Player player : players) {
                MovementStatusCommand.setValue(this.plugin, player, this.type, this.value);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        for (Player player : PaperUtil.toPlayers(this.idMap.remove(request.getRequestId()))) {
            MovementStatusCommand.setValue(this.plugin, player, this.type, MovementStatusValue.ALLOWED);
        }
    }

    public static MovementStatusCommand disableJumping(PaperCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "disable_jumping", CommandConstants.DISABLE_JUMPING_DURATION, MovementStatusType.JUMP, MovementStatusValue.DENIED, false);
    }

    public static MovementStatusCommand invertControls(PaperCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "invert_wasd", "walk", CommandConstants.INVERT_CONTROLS_DURATION, MovementStatusType.WALK, MovementStatusValue.INVERTED, true);
    }

    public static MovementStatusCommand invertCamera(PaperCrowdControlPlugin plugin) {
        return new MovementStatusCommand(plugin, "invert_look", "look", CommandConstants.INVERT_CONTROLS_DURATION, MovementStatusType.LOOK, MovementStatusValue.INVERTED, true);
    }

    public Map<UUID, List<UUID>> getIdMap() {
        return this.idMap;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    public MovementStatusType getType() {
        return this.type;
    }

    public MovementStatusValue getValue() {
        return this.value;
    }

    @Override
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    public static final class Manager
    implements Listener {
        @EventHandler
        public void onJump(PlayerJumpEvent event) {
            boolean cantWalk;
            Player player = event.getPlayer();
            boolean cantJump = MovementStatusCommand.getValue(player, MovementStatusType.JUMP) == MovementStatusValue.DENIED;
            boolean bl = cantWalk = MovementStatusCommand.getValue(player, MovementStatusType.WALK) == MovementStatusValue.DENIED;
            if (cantJump || cantWalk) {
                event.setCancelled(true);
            }
        }
    }
}

