/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.crowdcontrol.plugin.paper.utils.BlockUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VeinCommand
extends RegionalCommandSync {
    private final String effectName = "vein";

    public VeinCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Contract(mutates="param1, param2")
    private static void addOreVein(List<Location> deepslateBlocks, List<Location> stoneBlocks, Location base) {
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    Location loc = base.clone().add((double)x, (double)y, (double)z);
                    Block block = loc.getBlock();
                    Material matType = block.getType();
                    if (matType == Material.DEEPSLATE) {
                        deepslateBlocks.add(loc);
                        continue;
                    }
                    if (block.isEmpty()) continue;
                    stoneBlocks.add(loc);
                }
            }
        }
    }

    @Contract(mutates="param1")
    private static void randomlyShrinkOreVein(List<Location> blockLocations) {
        if (blockLocations.isEmpty()) {
            return;
        }
        Collections.shuffle(blockLocations, random);
        int maxBlocks = 1 + random.nextInt(blockLocations.size());
        while (blockLocations.size() > maxBlocks) {
            blockLocations.removeFirst();
        }
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find any blocks to replace");
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        BlockUtil.BlockFinder finder = ((BlockUtil.BlockFinder.BlockFinderBuilder)((BlockUtil.BlockFinder.BlockFinderBuilder)BlockUtil.BlockFinder.builder().origin(player.getLocation()).maxRadius(6)).locationValidator(loc -> !loc.getBlock().isEmpty())).build();
        boolean success = false;
        for (int iter = 0; iter < 3; ++iter) {
            Ores ore = (Ores)RandomUtil.weightedRandom((Weighted[])Ores.values(), (int)Ores.TOTAL_WEIGHTS);
            ArrayList<Location> setBlocks = new ArrayList<Location>(8);
            ArrayList<Location> setDeepslateBlocks = new ArrayList<Location>(8);
            Location oreLocation = (Location)finder.next();
            if (oreLocation == null) continue;
            VeinCommand.addOreVein(setDeepslateBlocks, setBlocks, oreLocation);
            if (setBlocks.isEmpty() && setDeepslateBlocks.isEmpty()) continue;
            VeinCommand.randomlyShrinkOreVein(setBlocks);
            VeinCommand.randomlyShrinkOreVein(setDeepslateBlocks);
            setBlocks.forEach(blockPos -> blockPos.getBlock().setType(ore.getBlock()));
            setDeepslateBlocks.forEach(blockPos -> blockPos.getBlock().setType(ore.getDeepslateBlock()));
            success = true;
        }
        return success;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public static enum Ores implements Weighted
    {
        DIAMOND(Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, 6),
        IRON(Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, 6),
        COAL(Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, 6),
        EMERALD(Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, 6),
        GOLD(Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, 6),
        REDSTONE(Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, 6),
        LAPIS(Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, 6),
        ANCIENT_DEBRIS(Material.ANCIENT_DEBRIS, 3),
        QUARTZ(Material.NETHER_QUARTZ_ORE, 6),
        NETHER_GOLD(Material.NETHER_GOLD_ORE, 6),
        SILVERFISH(Material.INFESTED_STONE, Material.INFESTED_DEEPSLATE, 1),
        LAVA(Material.LAVA, 1);

        public static final int TOTAL_WEIGHTS;
        private final Material block;
        private final Material deepslateBlock;
        private final int weight;

        private Ores(Material block, Material deepslateBlock, int weight) {
            this.block = block;
            this.deepslateBlock = deepslateBlock;
            this.weight = weight;
        }

        private Ores(Material block, int weight) {
            this(block, block, weight);
        }

        public Material getBlock() {
            return this.block;
        }

        public Material getDeepslateBlock() {
            return this.deepslateBlock;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        static {
            TOTAL_WEIGHTS = Arrays.stream(Ores.values()).mapToInt(Ores::getWeight).sum();
        }
    }
}

