/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish;

import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.AbstractCondition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.ConditionFlags;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.SuccessCondition;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

abstract class AbstractListeningCondition<DataType>
extends AbstractCondition
implements SuccessCondition,
Listener {
    protected final Map<UUID, DataType> statuses = new HashMap<UUID, DataType>();
    @NotNull
    protected final DataType defaultStatus;

    protected AbstractListeningCondition(int rewardLuck, @NotNull DataType defaultStatus, @Nullable ConditionFlags builder) {
        super(rewardLuck, builder);
        this.defaultStatus = defaultStatus;
    }

    @Override
    public void track(@NotNull UUID player) {
        this.statuses.put(player, this.defaultStatus);
    }

    @Override
    public void reset(@NotNull UUID player) {
        this.statuses.remove(player);
    }

    protected boolean hasStatus(@NotNull UUID player) {
        return this.statuses.containsKey(player);
    }

    protected boolean hasStatus(@NotNull Player player) {
        return this.hasStatus(player.getUniqueId());
    }

    @NotNull
    protected DataType getStatus(@NotNull UUID player) {
        return this.statuses.getOrDefault(player, this.defaultStatus);
    }

    @NotNull
    protected DataType getStatus(@NotNull Player player) {
        return this.getStatus(player.getUniqueId());
    }

    protected void setStatus(@NotNull UUID player, @NotNull DataType status) {
        this.statuses.put(player, status);
    }

    protected void setStatus(@NotNull Player player, @NotNull DataType status) {
        this.setStatus(player.getUniqueId(), status);
    }

    protected void computeStatus(@NotNull UUID player, @NotNull Function<DataType, DataType> modifier) {
        if (!this.statuses.containsKey(player)) {
            return;
        }
        this.statuses.compute(player, (key, value) -> modifier.apply(value));
    }

    protected void computeStatus(@NotNull Player player, @NotNull Function<DataType, DataType> modifier) {
        this.computeStatus(player.getUniqueId(), modifier);
    }
}

